local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venusjson = require "venusjson"
local Object = require "classic"



--管理一组3d模型
local threesticker = Object:extend();

function threesticker:new()
  self.assets = {}
end

--传入数据表，解析数据
function threesticker:ParseConfig(config,para)
  --_COROUTINES_ON();
  local res = true;
  --local json = venusjson.LaodJsonFile(config);
  if (config["parts3d"]) then   --模型
    local parts3DValue = config["parts3d"];
    local modellist = parts3DValue["modelList"];
    for key, value in pairs(modellist) do
      local modelName = value["fileName"];

      local modelPath = para[1] .. "/" .. modelName;
      
      local model = apollonode.ModelNode();
      res = res and model:CreateResource(modelPath);
      model:SetShow(false);
      model:SetLoop(true);
      model:Play();
      renderqueue:After(model);
      table.insert(self.assets, model);
    end
  end
  return res;
  --_COROUTINES_OFF();
end

function threesticker:SetShow(isshow)
  for _, model in ipairs(self.assets) do
    model:SetShow(isshow);
  end  
end

function threesticker:SetRootNode(node)
  for _, model in ipairs(self.assets) do
    node:AttachNode(model);
  end  
end

function threesticker:Update(timespan)
  for _, model in ipairs(self.assets) do
    model:UpdateAnimation(timespan);
  end
end


return threesticker;