local blendshape = require "shapemodel"
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local venusjson = require "venusjson"
local mathfunction = require "mathfunction"
local Object = require "classic"
local renderqueue = require "apolloutility.renderqueue"
local tongue = require "blendshape.tongue"
local lowerteeth = require "blendshape.lowerteeth"
local animation = require "blendshape.animationmodel"
local eye = require "blendshape.eye"
local eyelash = require "blendshape.eyelash"
local stationary = require "blendshape.stationary"
local extra = require "blendshape.extra"
local face = require "blendshape.face"

local venusblendshape = Object:extend();

function venusblendshape:new()
  self.models = {}  -- model table
end


--全部初始化工作--
function venusblendshape:ParseConfig(modelconfig)
	--load of face--	
  if modelconfig["face"] == nil then
    self.show = false;
    return true;
  end
  
	self.show = false;
    
  self.zPos = modelconfig.zPosition or 0;
  self.zPos = self.zPos - 2000;
  
  local bindboxV = mathfunction.Aabbox3d( mathfunction.vector3(-1,-1, self.zPos -1),
                                          mathfunction.vector3(1,1, self.zPos));   

  self.renderbefore = modelconfig.renderbefore or false;
  
  if modelconfig.lightdirection then
    local dir = modelconfig.lightdirection;
    self.direct = apollonode.LightNode(apolloengine.LightComponent.LT_DIRECTIONAL);
    self.direct:SetLocalDirection(mathfunction.vector3(dir[1],dir[2],dir[3]));
    if modelconfig.lightcolor then
      local color = modelconfig.lightcolor;
      self.direct:SetColor(mathfunction.vector3(color[1],color[2],color[3]));
    else
      self.direct:SetColor(mathfunction.vector3(1,1,1));
    end    
  end
  if modelconfig.ambientcolor then  
    self.ambient = apollonode.LightNode(apolloengine.LightComponent.LT_AMBIENT);
    local color = modelconfig.ambientcolor;
    self.ambient:SetColor(mathfunction.vector3(color[1],color[2],color[3]));
  end
  if modelconfig.skybox and 6 == #modelconfig.skybox then  
    self.skybox = apolloengine.TextureEntity();      
    for _, p in ipairs(modelconfig.skybox) do        
      --self.skybox:PushMetadata(apolloengine.TextureFileMetadata(p));
      self.skybox:PushMetadata(apolloengine.TextureFileMetadata( apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,
      1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,--默认repeat
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,p));
    end

    self.skybox:CreateResource();
    apolloengine.IMaterialSystem:SetGlobalParameter(apolloengine.ShaderEntity.SKY_BOX, self.skybox);
    apolloengine.ShaderEntity.EVN_SCALE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"ENV_SCALE");
    local env_scale = modelconfig.env_scale or 1;
    apolloengine.IMaterialSystem:SetGlobalParameter(apolloengine.ShaderEntity.EVN_SCALE,mathfunction.vector1(env_scale));
  end
  
  -- face
  if modelconfig["face"] ~= nil then
    self.face_model = face();
    
    local face_config = modelconfig.face;
    self:SetModel(self.face_model, face_config, nil, bindboxV, self.renderbefore);
        
    -- pos related parameters
    self.pos_adjust = mathfunction.vector3(face_config.pos[1],face_config.pos[2],face_config.pos[3]);    
  end 
  
  --eyelash
  if modelconfig["eyelash"] ~= nil then
    local eyelash = eyelash();
    self:SetModel(eyelash, modelconfig.eyelash, self.face_model, bindboxV, self.renderbefore);
  end 
    
  --extra blendshape model
  if modelconfig["extra"] ~= nil then
    local extra = extra();
    self:SetModel(extra, modelconfig.extra, self.face_model, bindboxV, self.renderbefore);
  end 

  if modelconfig["eyes"] ~= nil then
    self.eyes = {};
    local eyesConfig = modelconfig.eyes;
    --left eye
    if eyesConfig["left"] ~= nil then
      local lefteye = eye();
      self:SetModel(lefteye, eyesConfig.left, self.face_model, bindboxV, self.renderbefore);
      table.insert(self.eyes, lefteye);  
    end
    
    --right eye
    if eyesConfig["right"] ~= nil then
      local righteye = eye();
      self:SetModel(righteye, eyesConfig.right, self.face_model, bindboxV, self.renderbefore);
      table.insert(self.eyes, righteye);  
    end
  end
  
	--lower_teeth
   if modelconfig["lower_teeth"] ~= nil then
    local lower_teeth = lowerteeth();
    self:SetModel(lower_teeth, modelconfig.lower_teeth, self.face_model, bindboxV, self.renderbefore);
  end 
  
  --tongue
  if modelconfig["tongue"] ~= nil then
    local tongue = tongue();
    self:SetModel(tongue, modelconfig.tongue, self.face_model, bindboxV, self.renderbefore);
  end 
  
	--stationary
  if modelconfig["stationary"] ~= nil then
    local stationaryConfig = modelconfig.stationary;
    for meshKey, meshitems in pairs(stationaryConfig) do
      local stationary = stationary();
      self:SetModel(stationary, meshitems, self.face_model, bindboxV, self.renderbefore);
    end
   end
   
	--animation
	if modelconfig["animation"] ~= nil then
    local animationConfig = modelconfig.animation;
    for meshKey, meshitems in pairs(animationConfig) do
      local animation = animation();
      self:SetModel(animation, meshitems, self.face_model, bindboxV, self.renderbefore);
    end
	end

  self.root_node = apollonode.TransNode();
	self.root_node:AttachNode(self.face_model:GetModel());
  return true;
end

function venusblendshape:SetPosition(est)
  if(est ~= nil) then
    self.root_node:SetLocalRotation(est.rotation);
--    self.face_model:SetLocalRotation(self.rot_adjust);
--    self.face_model:SetLocalScale(self.scale_adjust);
    self.root_node:SetLocalPosition(est.position+self.pos_adjust);
  end
end

function venusblendshape:ReceiveBlendShapeDatas(masqueradeResult)
  if masqueradeResult == nil then
    return false;
  end
  local weights_dict = masqueradeResult.blendshapeWeight;
  ---这里如果从ARKit得到的weights_dict为空，就把人脸设置为不可见
  if weights_dict == nil or next(weights_dict) == nil then
    return false;
  end
  
  self:UpdateEyeLocation(masqueradeResult.lookAt);
  
  -- update the weights, from up to down
  self:AdjustWeight(self.face_model, masqueradeResult);
  self:ReceiveWeights(weights_dict);
  self:UpdatePosition(weights_dict);
  return true;
end

function venusblendshape:UpdatePosition(weights_dict)
  for i = 1, #self.models do
    local model = self.models[i];
    model:UpdatePosition(weights_dict);
  end
end

function venusblendshape:AdjustWeight(model, weights_dict)
  if(model ~= nil) then
    model:AdjustWeight(weights_dict);
    
    local attached_models = model:GetAttachedModels();    
    if (not attached_models or not next(attached_models)) then
      return;
    end
    
    for i = 1, #attached_models do
      local sub_model = attached_models[i];
      self:AdjustWeight(sub_model, weights_dict);
    end
  end
end

function venusblendshape:ReceiveWeights(weights_dict)
  for i = 1, #self.models do
    local model = self.models[i];
    if (model:HasBlendshape()) then
      model:ReceiveWeights(weights_dict);
    end
  end
end

----这个函数用于接受人眼观看方向，更新眼珠方向
function venusblendshape:UpdateEyeLocation(lookat_v3)
  if(not self.eyes) then
    return;
  end
  
  local look_from = mathfunction.vector3(0.0,0.0,1.0);
   
  for i = 1, #self.eyes do
    local eye = self.eyes[i];
    eye:UpdateLocation(lookat_v3);
  end
end

function venusblendshape:Update(def)
  --self:UpdateEyeLocation();
  for i = 1, #self.models do
    self.models[i]:UpdateModel(def);
  end
end

function venusblendshape:ShowModel(show)
  self.show = show;
  for i = 1, #self.models do
    self.models[i]:SetShow(show);
  end
end

function venusblendshape:setRenderQueue(model)
  if self.renderbefore == true then
    renderqueue:Before(model);
  else
    renderqueue:After(model);
  end
  local bindboxV = mathfunction.Aabbox3d(mathfunction.vector3(-1,-1, self.zPos -1),
  mathfunction.vector3(1,1,self.zPos));   
  model:SetBindBox(bindboxV);
  model:SetCull(false);
end

function venusblendshape:SetModel(model, config, attach_to_node, bindbox, render_before)
  if (model ~= nil ) then 
    model:CreateModel(config, attach_to_node, bindbox, render_before);  
    table.insert(self.models, model);  
  end
end

function venusblendshape:EnableARKit(enable)
  self.face_model:EnableARKit(enable);
end

return venusblendshape;
