local mathfunction = require "mathfunction"
local utility = require "blendshape.bsutility"
local model = require "blendshape.model"

local stationary = model:extend();

function stationary:new()
  stationary.super.new(self);
  self.show_mesh = true;
end

function stationary:CreateModel(config, attach_to_model, boundingbox, render_before)
  if (config ~= nil) then
    self.model = utility.CreateModel(config.mesh, config.render, config.texture, config.normal, config.pbr_amr, config.pos, config.outline);
  end
  
  if (self.model ~= nil) then
      self.position = self.model:GetLocalPosition();
      self.rotation = config.rotation;
      self.translation = config.translation;
      self.hide = config.hide;
  end  
    
  self:AttachToModel(attach_to_model);  
  self:SetBindBox(boundingbox);
  self:SetRenderQueue(render_before);
end

function stationary:AdjustWeight(weights_dict)
end

function stationary:SetShow(show)
  if (self.model ~= nil) then
    self.model:SetShow(show and self.show_mesh);
  end
end

function stationary:UpdatePosition(weights_dict)
  if self.rotation ~= nil then
    local rot = self.rotation;
    local w = weights_dict[rot.blendshape];
    local quat = mathfunction.Mathutility:YawPitchRoll(
      math.rad(rot.value[2] * w),
      math.rad(rot.value[1] * w),
      math.rad(rot.value[3] * w));
    self.model:SetLocalRotation(quat);
  end
  
  if self.translation ~= nil then
    local trans = self.translation;
    local w = weights_dict[trans.blendshape];
    local trans = mathfunction.vector3(
      trans.value[1] * w,
      trans.value[2] * w,
      trans.value[3] * w);
    self.model:SetLocalPosition(trans + self.position);
  end
  
  if self.hide ~= nil then
    local hide = self.hide;
    local showMesh = true;
    for i = 1, #self.hide do
      local w = weights_dict[hide[i].blendshape];
      if self:IsHide(hide[i].value[1], hide[i].value[2], w) == true then
        showMesh = false;
        break;
      end
    end
    self.show_mesh = showMesh;
  end
end

function stationary:IsHide(minv, maxv, w)
  if minv >= maxv then
    return false;
  end
  if w < minv or w > maxv then
    return false;
  end
  if self.show_mesh == false then
    return true;
  end
  local len = maxv - minv;
  local step = len / 5;
  if w <= maxv - step then
    return true;
  end
  return false;
end

return stationary;