local mathfunction = require "mathfunction"
local utility = require "blendshape.bsutility"
local model = require "blendshape.model"

local lowerteeth = model:extend();

function lowerteeth:new()
  lowerteeth.super.new(self);
end

function lowerteeth:CreateModel(lowerteeth_config, attach_to_model, boundingbox, render_before)
  if (lowerteeth_config ~= nil) then
    self.model = utility.CreateModel(lowerteeth_config.mesh, lowerteeth_config.render, lowerteeth_config.texture, lowerteeth_config.normal, lowerteeth_config.pbr_amr, lowerteeth_config.pos, lowerteeth_config.outline);
  end
  
  if (self.model ~= nil) then
    self.lowerteeth_trans_left = lowerteeth_config.trans_jaw_left.weight;
    self.lowerteeth_trans_right = lowerteeth_config.trans_jaw_left.weight;
    self.lowerteeth_trans_forward = lowerteeth_config.trans_jaw_forward.weight;
    self.lowerteeth_rot = lowerteeth_config.rot_angle.weight;
    self.trans_lowteeth = self.model:GetLocalPosition();
  end
  
  self:AttachToModel(attach_to_model);  
  self:SetBindBox(boundingbox);
  self:SetRenderQueue(render_before);
end

function lowerteeth:UpdatePosition(weights_dict)
  if (self.model ~= nil) then  
    local jawLeftWeight = weights_dict[jawLeftName] or 0;
    local jawRightWeight = weights_dict[jawRightName] or 0;
    local jawForwardWeight = weights_dict[jawForwardName] or 0;
    local jawOpenWeight = weights_dict[jawOpenName] or 0;   

    local dx = 0;
    local dz = 0;
    if (jawLeftWeight ~= nil) then
      dx = -self.lowerteeth_trans_left*jawLeftWeight;
    end
    if (jawRightWeight~= nil) then
      dx = dx + self.lowerteeth_trans_right*jawRightWeight;
    end
    if (jawForwardWeight ~= nil) then
      dz = self.lowerteeth_trans_forward*jawForwardWeight;
    end
    local trans = mathfunction.vector3(dx, 0.0, dz);     
    self.model:SetLocalPosition(self.trans_lowteeth + trans);

    local quat2 = mathfunction.Mathutility:YawPitchRoll(math.rad(0.0),math.rad(self.lowerteeth_rot*jawOpenWeight),math.rad(0.0));      
    self.model:SetLocalRotation(quat2);     
  end
end

return lowerteeth;