local mathfunction = require "mathfunction"
local utility = require "blendshape.bsutility"
local bsmodel = require "blendshape.bsmodel"
local blendshape = require "shapemodel"

local face = bsmodel:extend();

function face:new()
  face.super.new(self);
  self.weights = {};
  self.bs_names = {};
  self.bs_correct = {};
  self.adjust_weight = false;
end

function face:CreateModel(face_config, attach_to_node, boundingbox, render_before)
  local bs_weights = {};
  
  if (face_config ~= nil) then
    self.bs = blendshape.BS();--调用构造函数    
    self.model = utility.ReadBlendshape(face_config, bs_weights, self.bs, self.bs_map);
  end
  
  if (self.model ~= nil) then
    for i=1, #bs_weights do
      self.bs_names[i] = bs_weights[i]["name"];
      self.bs_correct[i] = bs_weights[i]["correct"];
    end
    
    utility.SetBlendshapeNameIndex(self.bs_names);
    
    -- pos related parameters
    self.pos_adjust = mathfunction.vector3(face_config.pos[1],face_config.pos[2],face_config.pos[3]);
    
    if face_config["rot"] ~= nil then
      self.rot_adjust = mathfunction.Mathutility:YawPitchRoll(math.rad(face_config.rot[2]), math.rad(face_config.rot[1]), math.rad(face_config.rot[3]));
    else
      self.rot_adjust = mathfunction.Mathutility:YawPitchRoll(0,0,0);
    end
    if face_config["scale"] ~= nil then
      self.scale_adjust = mathfunction.vector3(face_config.scale[1],face_config.scale[2],face_config.scale[3]);
    else
    self.scale_adjust = mathfunction.vector3(1,1,1);
    end
    if face_config["start_close_weight"] ~= nil then
      self.start_close_weight = face_config.start_close_weight;
    end
    if face_config["end_close_weight"] ~= nil then
      self.end_close_weight = face_config.end_close_weight;
    end
    
    if self.start_close_weight ~= nil and self.end_close_weight ~= nil then
      self.adjust_weight = true;
      self.eye_close_weight = 1.0/(self.end_close_weight * self.end_close_weight);
    end
    
    self:SetBindBox(boundingbox);
    self:SetRenderQueue(render_before);
  end
end

function face:UpdatePosition(weights_dict)
  if(self.model ~= nil) then
    self.model:SetLocalRotation(self.rot_adjust);
    self.model:SetLocalScale(self.scale_adjust);
  end
end


function face:ReceiveWeights(weights_dict)
    --更新blendshape的vbo(人脸，眼睫毛)
  if self.model ~= nil and self.bs ~= nil then
    --接受weights, 计算blend
    local face_weights = {};
    for i=1, #self.bs_names do
      local name = self.bs_names[i];
      face_weights[i] = weights_dict[name];
    end
    
    self.bs:ReceiveWeights(face_weights);
    
    local vertexstream = self.bs:GetBlendShape();
    self.model.render:FlushVertexBuffer(vertexstream);
  end
end

--function face:GetLookAtPoints()
--  local lookat = nil;
--  if (self.bs ~= nil) then
--    lookat = self.bs:ReceiveLookAtPoints();
--    if lookat == nil or (math.abs(lookat:x())<0.00001 and math.abs(lookat:y())<0.00001 and math.abs(lookat:z())<0.00001) then
--      lookat = mathfunction.vector3(0.0,0.0,1.0);
--    end
--  end 
--  return lookat;
--end

function face:AdjustWeight(masqueradeResult)
  local weights_dict = masqueradeResult.blendshapeWeight;
  if self.adjustWeight then
    weights_dict[eyeBlinkLName] = self:AdjustBlinkWeight(weights_dict[eyeBlinkLName]);
    weights_dict[eyeBlinkRName] = self:AdjustBlinkWeight(weights_dict[eyeBlinkRName]);
  end
  
  ---将各权重赋予对应weights位置
  if self.model ~= nil then
    for i=1, #self.bs_names do
      local name = self.bs_names[i];
      local weight = weights_dict[name];
      if weight ~= nil then
        local correct = self.bs_correct[i];
        if correct ~= nil then
          weight = weight * correct;
          if weight > 1 then
            weight = 1;
          end
        end
      else
        weight = 0;
      end
      -- assign back
      weights_dict[name] = weight;
      --self.weights[i] = weight;
    end
  end
end

function face:AdjustBlinkWeight(weight)
  -- weight: [0,1]
  local result = weight * weight * self.eye_close_weight;
  if result < self.start_close_weight then
    result = 0;
  else
    result = (result - self.start_close_weight) * (1.0 / (1.0 - self.start_close_weight));
    if result > 1 then
      result = 1;
    end
  end
  return result;
end

function face:EnableARKit(enable)
  if(self.bs ~= nil) then
    self.bs:EnableARKit(enable);
  end  
end
return face;