local mathfunction = require "mathfunction"
local utility = require "blendshape.bsutility"
local model = require "blendshape.model"

local eye = model:extend();

function eye:new()
  model.super.new(self);
  self.eye_scale = {1.0, 1.0};
end

function eye:CreateModel(config, attach_to_model, boundingbox, render_before)
  if (config ~= nil) then
    self.model = utility.CreateModel( config.mesh, config.render, config.texture, config.normal, config.pbr_amr, config.pos, config.outline);
  end
  
  if (self.model ~= nil) then
    self.eye_scale = config.dir_scale or {1.0, 1.0};
  end
  
  self:AttachToModel(attach_to_model);  
  self:SetBindBox(boundingbox);
  self:SetRenderQueue(render_before);
end

function eye:UpdateLocation(lookat_v3)
  local look_from = mathfunction.vector3(0.0,0.0,1.0);
  
  local look_at = self:ScaleLookat(lookat_v3,  self.eye_scale[1],  self.eye_scale[2]);

  if self.model ~= nil then
    local quat = mathfunction.Mathutility:AxisToAxis(look_from,look_at);
    self.model:SetLocalRotation(quat);
  end
end

function eye:ScaleLookat(lookat_v3, scaleX, scaleY)
  local x = lookat_v3:x();
  local y = lookat_v3:y();
  if scaleX ~= nil then
    x = x * scaleX;
  end
  if scaleY ~= nil then
    y = y * scaleY;
  end
  local z = math.sqrt(1.0 - x * x - y * y);
  return mathfunction.vector3(x, y, z);
end

return eye;