local mathfunction = require "mathfunction"
local utility = require "blendshape.bsutility"
local bsmodel = require "blendshape.bsmodel"
local blendshape = require "shapemodel"

local extra = bsmodel:extend();

function extra:new()
  extra.super.new(self);
  self.attch_index = {};
end

-- attach to node
function extra:AttachToModel(other_model)
  if (other_model ~= nil and self.model ~= nil) then
    local internal_model = other_model:GetModel();
    if (internal_model ~= nil) then
      internal_model:AttachNode(self.model);
      table.insert(other_model:GetAttachedModels(), self); 
    end
    
    if (other_model:HasBlendshape()) then
      local bs_map = other_model:GetBlendshapeMap();
      for i=1, #self.bs_weights do
        local attachName = self.bs_weights[i]["attachName"];
        self.attch_index[i] = bs_map[attachName];
      end
    end    
  end
end

function extra:ReceiveWeights(weights_dict)
  if(self.model ~= nil) then
    local weights_el = {};
    for i=1, #self.attch_index do
      local name = BlendshapeNameIndexDict[self.attch_index[i]];
      weights_el[i] = weights_dict[name];
    end
    self.bs:ReceiveWeights(weights_el);
  
    local vertexstream = self.bs:GetBlendShape();
    self.model.render:FlushVertexBuffer(vertexstream);
  end
end

function extra:GetBsMap()
  return self.bs_map;
end

function extra:AdjustWeight(weights_dict)
end

return extra;