local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local Object = require "classic"
local renderqueue = require "apolloutility.renderqueue"
require "math"

eyeBlinkLName = "eyeBlink_L";
eyeBlinkRName = "eyeBlink_R"
jawOpenName = "jawOpen";
jawLeftName = "jawLeft";
jawRightName = "jawRight";
jawForwardName = "jawForward";
mouthPuckerName = "mouthPucker";
mouthSmileName = "mouthSmile";
mouthLeftName = "mouthLeft";
mouthRightName = "mouthRight";

EPSILON = 1e-3; -- math epsilon

-- blend shape name-index dictionary, used for all models
BlendshapeNameIndexDict = {};

bsutility = {}

function bsutility.CreateAnimationModel(rootpath, pos, loop, playNow)
    local model = apollonode.ModelNode();
  
  if (model:CreateResource(rootpath) == false) then
    LOG("3D Emoji load failed: "..rootpath);
    model = nil; 
  else
    if (pos ~= nil) then
      model:SetLocalPosition(mathfunction.vector3(pos[1],pos[2],pos[3]));
    end
    model:SetShow(false);
    model:SetLoop(loop);
    if (playNow == true) then
      model:Play();
    end
  end
  return model;  
end

function bsutility.CreateModel(mesh, render, texture, normal, pbr_amr, pos, outline)
  local model = apollonode.MeshNode();
  model:SetShow(false);
  model.render:SetKeepSource(true);
  
  if(texture ~= nil) then
    model:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,texture);
    model:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_ALDEBO,texture);
  end
  
  if normal ~= nil then
    model:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_NORMAL,normal);
    model:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_BUMP,normal);
  end
  
  if pbr_amr ~= nil then
    model:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_AMR,pbr_amr);
  end
  
  if model:CreateResource(mesh,render,Nil,Nil,Nil,Nil,apolloengine.VertexBufferEntity.MU_DYNAMIC, outline) == false then
    LOG("3D Emoji load failed: "..mesh);
    model = nil;
    return model;
  end
    
  if(pos ~= nil) then 
    model:SetLocalPosition(mathfunction.vector3(pos[1],pos[2],pos[3]));      
  end  
  return model;
end

function bsutility.ReadBlendshape(intable, weights, bs, bsMap)
  local render  = intable.render;
	local outline = intable.outline;
	local pos     = intable.pos;
	local texture = intable.texture;
	local mesh    = intable.mesh;
	local normal = intable.normal;
	local pbr_amr = intable.pbr_amr;

	local model = bsutility.CreateModel(mesh, render, texture, normal, pbr_amr, pos, outline);
  
  if (model == nil) then
    model= nil;
    return model;
  end
  
	local vertexstream = model.render:GetVertexStream();
  if bs:load_blendshape(vertexstream) == false then
    LOG("3D Emoji blendshape load failed: "..mesh);
    model= nil;
    return model;
	end
	
	local weightsCount = 0;
  
	for meshesKey, meshesValue in pairs(intable.blendshape.models) do
    local meshpath = intable.blendshape.path .. meshesValue .. ".mesh";
    local bsModel = bsutility.CreateModel(meshpath, render, texture);
    
    if (bsModel == nil) then
      model= nil;
      return model;
    end
    
    vertexstream = bsModel.render:GetVertexStream();
    
    if bs:load_blendshape(vertexstream) == false then
      LOG("3D Emoji load failed as blendshape load failed: "..meshpath);
      model= nil;
      return model;
    end
    
    weightsCount = weightsCount + 1;
    weights[weightsCount] = {};
    weights[weightsCount]["name"] = meshesValue;
    bsMap[meshesValue] = weightsCount;
    if intable.is_attach == 1 then
        weights[weightsCount]["attachName"] = intable.attach[weightsCount];
    end
    if intable.blendshape["correct"] ~=nil then
        weights[weightsCount]["correct"] = intable.blendshape.correct[meshesValue];
    end
	end   
	
	bs:build_blendshape();
  return model;
end

function bsutility.SetBlendshapeNameIndex(name_index_dict)
  BlendshapeNameIndexDict = name_index_dict;
end

function bsutility.SetRenderQueue(model, render_before, is_animation)
  if (model ~= nil ) then
    if render_before ~= nil and render_before == true then
      renderqueue:Before(model);
    else
      renderqueue:After(model);
    end
    
    if(not is_animation) then
      model:SetCull(false);
    end  
  end
end

function bsutility.GetStep(from, to, step)
  local absolute = math.abs(from - to);
  if (absolute < EPSILON) then
    return 0;
  end
  
  local sign = (to - from) / absolute;
  return step * sign;
end

return bsutility;

