local mathfunction = require "mathfunction"
local utility = require "blendshape.bsutility"
local model = require "blendshape.model"
local blendshape = require "shapemodel"

-- model contains blendshape
local bsmodel = model:extend();

function bsmodel:new()
  bsmodel.super.new(self);
  self.weights = {}; -- the weights pass to venus engine
  self.bs_map = {};
  self.bs = nil;
  self.bs_names = {};
  self.bs_weights = {};
  self.has_blendshape = true;
end

function bsmodel:CreateModel(config, attach_to_model, boundingbox, render_before)
  if (config ~= nil) then
    self.bs = blendshape.BS();--调用构造函数
    self.model = utility.ReadBlendshape(config, self.bs_weights, self.bs, self.bs_map);
  end
  
  self:AttachToModel(attach_to_model);  
  self:SetBindBox(boundingbox);
  self:SetRenderQueue(render_before);
end

function bsmodel:GetBlendshapeMap()
  return self.bs_map;
end

function bsmodel:ReceiveBlendShapeDatas()
  local weights_dict = nil;
  if(self.bs ~= nil) then
    weights_dict = self.bs:ReceiveBlendShapeDatas();
  end
  return weights_dict;
end

function bsmodel:ReceiveWeights(weights_dict)
end

return bsmodel;