local venusblendshape = require "blendshape.venusblendshape"
local posture = require "facecute.estimates.transposture"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"
local venusjson = require "venusjson"
local venuscore = require "venuscore"
local utility = require "blendshape.bsutility"
local libmasquerade = require "libmasquerade"
local mlbvt = require "machinelearningservice"
local likeapp = require "likeapp"


local blendshape={};
local landmarkNum = 106;

function blendshape:_InitBvt(w, h)
  self.cnnIris = mlbvt.MachinelearningService();
  self.cnnIris:SetType(6);
  local res = self.cnnIris:Init(w,h);
  if res ~= 0 then
    LOG("bvt iris init failed: "..res);
    return false;
  end
  self.cnnTongue = mlbvt.MachinelearningService();
  self.cnnTongue:SetType(10);
  res = self.cnnTongue:Init(w,h);
  if res ~= 0 then
    LOG("bvt tongue init failed: "..res);
    return false;
  end
  return true;
end

function blendshape:_InitMasquerade()
  self.masqueradeTracking = libmasquerade.FaceTracking();
  if self.masqueradeTracking:Init(
    "config_face_morphable.json",
    "3dmm_85.bin",
    "config_face_template.json",
    "blendshape.bin",
    "user_face_recon.json",
    "config.json") then
    return true;
  end
  return false;
end

function blendshape:_MasqueradeTrack()
  local size = videodecet:GetVideoSize();
  local ts = videodecet:GetVideoFrame();
  local faces = videodecet:GetFaces();
  if #faces > 0 and size and ts then    
    if not self.bvtInited then
      if self:_InitBvt(size[1], size[2]) then
        self.bvtInited = true;
      else
        self.cnnIris = nil;
        self.cnnTongue = nil;
        return false;
      end
    end
    
    local landmarks = {};
    local keyPoints = mathfunction.vector2array();
    local faceKeyPoints = videodecet:GetPixelFacekeypointArray();
    for i=1, landmarkNum do
      keyPoints:PushBack(faceKeyPoints:Get(i));
      landmarks[2*i-1] = faceKeyPoints:Get(i):x();
      landmarks[2*i] = faceKeyPoints:Get(i):y();
    end

    local eyes = self.cnnIris:Run(keyPoints,ts);
    local leftEye = mathfunction.vector2(eyes:Get(20):x(),eyes:Get(20):y());    
    local rightEye = mathfunction.vector2(eyes:Get(40):x(),eyes:Get(40):y());
    local bvtTongue = self.cnnTongue:Run(keyPoints,ts):Get(1):x();
    if leftEye:x() == 0 and leftEye:y() == 0 then
      leftEye = keyPoints:Get(105);
    end
    if rightEye:x() == 0 and rightEye:y() == 0 then
      rightEye = keyPoints:Get(106);
    end

    local pry = faces[1]:GetRotation();
    local euler = mathfunction.vector3(pry[1],pry[3],pry[2]);
    local visibility = likeapp.AI:GetFaceVisibility();
    self.masqueradeTracking:Track(ts, euler, landmarks, visibility, leftEye, rightEye, bvtTongue);        
    local bsNum = self.masqueradeTracking:GetBlendshapeNumber();
    self.masqueradeResult = {};
    self.masqueradeResult.blendshapeWeight = {};
    for i=1, bsNum do
      local name = self.masqueradeTracking:GetBlendshapeName(i-1);
      local weight = self.masqueradeTracking:GetBlendshapeWeight(i-1);
      self.masqueradeResult.blendshapeWeight[name] = weight;
    end
    self.masqueradeResult.lookAt = self.masqueradeTracking:GetLookat();
    self.masqueradeResult.tongue = self.masqueradeTracking:GetTongue();
    return true;
  end
  return false;
end

function blendshape:Initialize()
end

function blendshape:LoadConfig(path)
  self.loaded = false;
  local rootconfig = venusjson.LaodJsonFile(path);
  if rootconfig.blendshape then    
    local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
    local rootdir = pathDir.."/";
    venuscore.IFileSystem:SetResourcePath(rootdir);
    self.blendshape = venusblendshape();
    if self.blendshape:ParseConfig(rootconfig.blendshape) == false then
      self.blendshape = nil;
      return false;
    end

    self.blendshape:ShowModel(false);
    if self:_InitMasquerade() == false then
      LOG("Failed to init masquerade.");
      self.masqueradeTracking = nil;
      return false;
    end
    
    self.bvtInited = false;
    
    self.loaded = true;
  end
  return true;
end

function blendshape:ReleaseResource()
  if self.blendshape then
    --self:_DisableARkit();
    self.blendshape = nil;
    self.bvtInited = false;
    self.masqueradeTracking = nil;
    self.cnnIris = nil;
    self.cnnTongue = nil;
  end
end


function blendshape:ReceiveBlendShapeDatas(masqueradeResult)
  return self.blendshape:ReceiveBlendShapeDatas(masqueradeResult);
end


function blendshape:Positioning()
  local faces = videodecet:GetFaces();
  if faces then
    posture:Update(faces,maincamera);
    local postures = posture:GetPostures();
    if #postures >= 1 then
      local est = postures[1];
      self.blendshape:SetPosition(est);
      return true;
    end
  end
  return false;
end


function blendshape:Update(def)
  if self.blendshape then
    if self.loaded == true and self:Positioning() and self:_MasqueradeTrack() and self:ReceiveBlendShapeDatas(self.masqueradeResult) then
      self.blendshape:Update(def);
      self.blendshape:ShowModel(true);
    else
      self.blendshape:ShowModel(false);
    end    
  end
end

return blendshape;
