local mathfunction = require "mathfunction"
local utility = require "blendshape.bsutility"
local model = require "blendshape.model"

local animationmodel = model:extend();

function animationmodel:new()
  animationmodel.super.new(self);
end

function animationmodel:CreateModel(animation_config, attach_to_model, boundingbox, render_before)
  if (animation_config ~= nil) then
    self.model = utility.CreateAnimationModel(animation_config.mesh, animation_config.pos, true, true);
  end
  
  self:AttachToModel(attach_to_model); 
  self:SetBindBox(boundingbox);
  self:SetRenderQueue(render_before,true);
end

function animationmodel:UpdateModel(def)
  if (self.model ~= nil) then
    self.model:UpdateAnimation(def);
  end
end

return animationmodel;