
local SquareInfo = require "biugo.squareinfo";
local stringsplit = require "stringsplit"
local likeapp = require "likeapp"

--每一行代表一帧
--一帧包含四边形的四个顶点，空格分开
local keypointcount = 4;


local paserservice = {}

function paserservice:GetKeyPointCount()
  return keypointcount;
end


function paserservice:PaserFile(agent, index, fullpath, size, id,splitInfo)  

  local file = io.open(fullpath, "rb")
  if file then
    file:close();
  end
  if file ~= nil then
    local index_ = 1;
    for line in io.lines(fullpath) do
      local data = stringsplit(line, "%s", tonumber);
      local square_coordinate_count = #data;
      if square_coordinate_count ~= 8 then
        LOG("Data file fullpath is: " .. fullpath);
        LOG("Number count is: " .. tostring(square_coordinate_count));
        LOG("Keypoint data error! Line number: " .. tostring(index_));  --关键点数据不对
        LOG("Line content is: " .. tostring(line));
      else
        local squareinfo = SquareInfo(size,splitInfo);
        squareinfo:SetID(id);
        index_ = index_ + 1;
        squareinfo:PushSquare(data[1],data[2],data[3],data[4],data[5],data[6],data[7],data[8]);
        agent:CallbackFunction(index, squareinfo); --得到了一帧关键点
      end
    end
  else
    ERROR(fullpath .. " do not exist!");
    likeapp.AI:OnCallback(0,fullpath .. " do not exist!");
  end
end

return paserservice;