  
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local MaskRender = require "biugo.mask_render"
local venuscore = require "venuscore"
local videodecet = require "videodecet"
local biugodefined = require "biugo.defined"
local emptyimage = require "apolloutility.emptyimage"
local stringsplit = require "stringsplit"
local SquareInfo = require "biugo.squareinfo";
local Object = require "classic"
local likeapp = require "likeapp"





local MaskSequenceBase = Object:extend();

function MaskSequenceBase:new(customID,channel, isText, materialName, alphaMode,splitInfo)
  self.customID = customID;
  self.maskChannel = channel;
  self.isText = isText; --是否是文字
  self.isShow = nil;
  self.maskID = nil;
  self.mask_texture = nil;
  self.custom_texture = nil;
  self.custom_texture_size = nil;
  self.material_name = materialName;
  self.alpha_mode = alphaMode;
  self.split_info = splitInfo;
  
  local strMaterial = self:AssemblyMaterial();
  --self.maskrender = MaskRender(biugodefined.mask_video_material_path);
  self.maskrender = MaskRender(strMaterial);
  
  --default mask texture
  self.empty_mask_ts = apolloengine.TextureStream();
  self.empty_mask_ts:SetStreamType(
    mathfunction.vector2(4,1),
    apolloengine.TextureEntity.PF_L8);
  for u=1, 4 do
    self.empty_mask_ts:SetPixel(u, 1, mathfunction.vector1(0.0));
  end

  self.empty_mask_texture = apolloengine.TextureEntity();
  self.empty_mask_texture:PushMetadata(
  apolloengine.TextureBufferMetadata(
    apolloengine.TextureEntity.TU_WRITE,
    1, false,
    apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
    apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
    apolloengine.TextureEntity.TF_LINEAR,
    apolloengine.TextureEntity.TF_LINEAR,
    self.empty_mask_ts));
  self.empty_mask_texture:CreateResource();
  self.mask_texture = self.empty_mask_texture;
  
  
  -- coustom texture
  -- 用户没有设置图片的情况下，不需要绘制
  self.default_custom_ts = apolloengine.TextureStream();
    self.default_custom_ts:SetStreamType(
    	mathfunction.vector2(32,1),
    	apolloengine.TextureEntity.PF_R8G8B8A8);
    for u=1, 32 do
      self.default_custom_ts:SetPixel(u, 1, mathfunction.vector4(0.0,0.0,0.0,0.0));
  end 
  self.custom_texture = apolloengine.TextureEntity();
  self.custom_texture:PushMetadata(
  apolloengine.TextureBufferMetadata(
      apolloengine.TextureEntity.TU_WRITE,
      1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
       self.default_custom_ts));
  self.custom_texture:CreateResource();
end

function MaskSequenceBase:AssemblyMaterial()
  local alphamode_str = biugodefined.AlphaMode[self.alpha_mode];
  local shaderpart_str = biugodefined.Shaders[self.material_name];
  if alphamode_str == nil then
  end
  
  local material_begin = string.format(biugodefined.material_begin, alphamode_str);
    
  local materialsrc = material_begin .. shaderpart_str;
  materialsrc = materialsrc .. biugodefined.material_end;
  return materialsrc;
end

function MaskSequenceBase:SetSequence(s)
  self.maskrender:SetSequence(s);
end

function MaskSequenceBase:SetShow(isShow)
  if self.isShow ~= isShow then
    self.isShow = isShow;
    self.maskrender:SetShow(isShow);
  end
end




function MaskSequenceBase:ParseKeypointFile(keypointfilefullpath)
  --先判断文件存不存在
  local file = io.open(keypointfilefullpath, "rb")
  if file then
    file:close();
  end
  if file ~= nil then
    --创建解析服务
    self.parseservice = venuscore.IServicesSystem:Create("biugo.parseservice_keypoint");
    
    --获得分辨率和ID号
    local filename_with_suffix = nil;
    local filename_without_suffix = nil;
    --if string.find(keypointfilefullpath,":") then  --windows 
    --  filename_without_suffix = string.match(keypointfilefullpath,".+\\([^\\]*)%.%w+");
    --else
      filename_with_suffix = string.match(keypointfilefullpath,".+/([^/]*%.%w+)$");
    --end
    local idx = filename_with_suffix:match(".+()%.%w+$")
    if(idx) then
      filename_without_suffix = filename_with_suffix:sub(1, idx-1)
    else
      filename_without_suffix = filename_with_suffix
    end
    local splited_filename = stringsplit(filename_without_suffix,"_",tonumber);
    local split_component_cnt = #splited_filename;
    if split_component_cnt ~= 3 then
      ERROR("Key point file name error!");
      likeapp.AI:OnCallback(0,keypointfilefullpath .. "Key point file name format error!");
    end
    local size = {splited_filename[1],splited_filename[2]};
    local id = splited_filename[3];
    if self.customID == nil then
      self.maskID = id;
    else
      self.maskID = id;
    end
    
    self.squareframes = {};
    self.insertfunction = function(d)
      local squareinfo = SquareInfo:as(d);
      table.insert(self.squareframes,squareinfo);
      return true;
    end
    

    local agent, index = g_callbackhandle:RegisterCallback(self.insertfunction);
    self.parseservice:PaserFile(agent, index, keypointfilefullpath, size, self.maskID,self.split_info); 
    return true;
  else
    ERROR(keypointfilefullpath .. " do not exist!");
    likeapp.AI:OnCallback(0,keypointfilefullpath .. " do not exist!");
    return false;
  end
end

--对于文字要对识别框做调整
function MaskSequenceBase:TextUpdate(squareInfo)
  
  local square = squareInfo:GetSquare();
  local leftUpX ,leftUpY = squareInfo:ToPixelCoordinates(square[1][1],square[1][2]);
  local rightUpX, rightUpY = squareInfo:ToPixelCoordinates(square[2][1],square[2][2]);
  local leftDownX, leftDownY = squareInfo:ToPixelCoordinates(square[3][1],square[3][2]);
  local rightDownX, rightDownY = squareInfo:ToPixelCoordinates(square[4][1],square[4][2]);
  
  local customWidth = self.custom_texture_size:X();
  local customHeight = self.custom_texture_size:Y();
  local width = math.sqrt((leftUpX - rightUpX) * (leftUpX - rightUpX) + (rightUpX - rightUpY) * (rightUpX - rightUpY));
  local height = math.sqrt((leftUpX - leftDownX) * (leftUpX - leftDownX) + (rightUpX - leftDownY) * (rightUpX - leftDownY));
  
  if (width / height) == (self.customWidth / customHeight) then
    if width > customWidth and height > customHeight then
      --怎么缩放呢？
      local centerX = (leftUpX + rightDownX) / 2;
      local centerY = (leftUpY + rightDownY) / 2;
      local ratio = customWidth / width;
      leftUpX = (leftUpX - centerX) * ratio + centerX;
      leftUpY = (leftUpY - centerY) * ratio + centerY;
      rightUpX = (rightUpX - centerX) * ratio + centerX;
      rightUpY = (rightUpY - centerY) * ratio + centerY;
      leftDownX = (leftDownX - centerX) * ratio + centerX;
      leftDownY = (leftDownY - centerY) * ratio + centerY;
      rightDownX = (rightDownX - centerX) * ratio + centerX;
      rightDownY = (rightDownY - centerY) * ratio + centerY;
      
      local sx1,sy1 = self:ToRelativeCoordinates(leftUpX,leftUpY);
      local sx2,sy2 = self:ToRelativeCoordinates(rightUpX,rightUpY);
      local sx3,sy3 = self:ToRelativeCoordinates(leftDownX,leftDownY);
      local sx4,sy4 = self:ToRelativeCoordinates(rightDownX,rightDownY);
      
      local square_ = {};
      table.insert(square_,{sx1,sy1});
      table.insert(square_,{sx2,sy2});
      table.insert(square_,{sx3,sy3});
      table.insert(square_,{sx4,sy4});
      self.maskrender:Update(square_);
    elseif width > customWidth and height > customHeight then
      --将文字图片缩小1.6倍
      customWidth = customWidth / 1.2;
      customHeight = customHeight / 1.2;
      if customWidth < width and customHeight < height then
        local centerX = (leftUpX + rightDownX) / 2;
        local centerY = (leftUpY + rightDownY) / 2;
        local ratio = customWidth / width;
        leftUpX = (leftUpX - centerX) * ratio + centerX;
        leftUpY = (leftUpY - centerY) * ratio + centerY;
        rightUpX = (rightUpX - centerX) * ratio + centerX;
        rightUpY = (rightUpY - centerY) * ratio + centerY;
        leftDownX = (leftDownX - centerX) * ratio + centerX;
        leftDownY = (leftDownY - centerY) * ratio + centerY;
        rightDownX = (rightDownX - centerX) * ratio + centerX;
        rightDownY = (rightDownY - centerY) * ratio + centerY;
        
        local sx1,sy1 = self:ToRelativeCoordinates(leftUpX,leftUpY);
        local sx2,sy2 = self:ToRelativeCoordinates(rightUpX,rightUpY);
        local sx3,sy3 = self:ToRelativeCoordinates(leftDownX,leftDownY);
        local sx4,sy4 = self:ToRelativeCoordinates(rightDownX,rightDownY);
        
        local square_ = {};
        table.insert(square_,{sx1,sy1});
        table.insert(square_,{sx2,sy2});
        table.insert(square_,{sx3,sy3});
        table.insert(square_,{sx4,sy4});
        square = square_;
        self.maskrender:Update(square_);
      else
        local ratio = width / (customWidth * 2);
        local texcoord1 = 0.0 + ratio;
        local texcoord2= 1.0 - ratio;
        local square_texcoords = {{texcoord1,texcoord1},{texcoord2,texcoord1},{texcoord1,texcoord2},{texcoord2,texcoord2}};
        self.maskrender:Update2(square,square_texcoords);
      end
    end
  end
end



function MaskSequenceBase:Update(frameIndex)
  local keypoint_frame_count = #self.squareframes;
  local frameInd = frameIndex;
  
  if keypoint_frame_count == 0 then
    return;  --数据没读出来，不Update
  end
  
  if frameInd < 1 then
    frameInd = 1;
    ERROR("Frame index error! TheFrameIndex is: " .. tostring(frameIndex));
  end
  if frameInd > keypoint_frame_count then
    frameInd = keypoint_frame_count;
    ERROR("Frame index error! TheFrameIndex is: " .. tostring(frameIndex));
  end
  
  local squareInfo = self.squareframes[frameInd];

  local vertexArray, texcoordArray = squareInfo:GetTesslateData();

  if self.isText == true then  --文字做简单的缩放排版
    self:TextUpdate(squareInfo);
  else
    self.maskrender:Update(vertexArray,texcoordArray);
  end
    
    
  self.maskrender:SetMaskTexture(self.mask_texture,self.maskChannel);
  self.maskrender:SetCustomTexture(self.custom_texture);

end

return MaskSequenceBase;
