local renderqueue = require "apolloutility.renderqueue"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local Object = require "classic"
local masksequence = require "biugo.mask_sequence"
local biugodefined = require "biugo.defined"




local biugomanager = {};


function biugomanager:Initialize()
  self.masksequence = {};
end


function biugomanager:LoadConfig(configfile)
  local res = true;
  local config = venusjson.LaodJsonFile(configfile);
  local version = config.version or 1;
  local cutoutconfig = config.cout_out;
  if cutoutconfig then
    local pathDir= string.match(configfile, "(.+)/[^/]*%.%w+$");
    
    local isChangeRange = cutoutconfig.IsChangeRange or false;

    --read split config
    local Rows = 1;
    local Cols = 1;
    local splitconfig = cutoutconfig.SplitConfig;
    if splitconfig ~= nil then
      if splitconfig.Rows ~= nil then
        Rows = splitconfig.Rows;
      end
      if splitconfig.Cols ~= nil then
        Cols = splitconfig.Cols;
      end
    end
    
    local keypointfile = cutoutconfig.KeyPointFiles;
    if keypointfile then
      local keypointfilecount = #keypointfile;
      for i = 1,keypointfilecount do
        local channel = keypointfile[i].Channel;
        local isText = keypointfile[i].IsText or false;   --是否是文字
        
        --材质信息配置
        local materialName = "Simple";  --默认给简单材质，Dffuse贴图材质
        if version == 2 then
          materialName = "SimpleV2";   --拼接版本mask
        end
        local alphaMode = "Blend";
        local material = keypointfile[i].Material;
        if material ~= nil then
          if material.Name ~= nil then
            materialName = material.Name;
          end
          if material.AlphaMode ~= nil then
            alphaMode = material.AlphaMode;
          end
        end
        
        --customID号，对于多个rect文件对应一张用户图片的是需要CstomID号(
        --默认是从rect文件命中提取ID号码，如果提供了customID,则文件名中的ID号无效)
        local customID = keypointfile[i].CustomID;
        
        --分割信息，应对九宫格的需求
        local splitInfo = {};
        local splitLoc = {1,1};
        if keypointfile[i].Location ~= nil then
          local splicLocTemp = keypointfile[i].Location;
          local locNumCnt = #splicLocTemp;
          if locNumCnt == 2 then
            local rowTemp = splicLocTemp[1];
            local colTemp = splicLocTemp[2];
            if rowTemp > 0 and rowTemp <= Rows then
              splitLoc[1] = rowTemp;
            else
              ERROR("Split location config error: the row out of range");
              res = false;
            end
            if colTemp > 0 and colTemp <= Cols then
              splitLoc[2] = colTemp;
            else
              ERROR("Split location config error: the col out of range");
              res = false;
            end
          else
            ERROR("Split location config error: should provide row and col two value");
            res = false;
          end
        end
        table.insert(splitInfo,{Rows,Cols});
        table.insert(splitInfo,splitLoc);
        
        
        local maskseq = masksequence(customID,channel, isText, materialName, alphaMode, splitInfo);  --有多少个关键点文件就对应多少个mask
        renderqueue:After(maskseq);
        table.insert(self.masksequence,maskseq);
        local filename = keypointfile[i].Path;
        local fullpath = venuscore.IFileSystem:PathAssembly(pathDir.. "/" .. filename);
        res = res and maskseq:ParseKeypointFile(fullpath);
      end
    end
  end
  
  if res == false then
    self:ReleaseResource();  --加载失败，自己调用卸载，避免外部不调用卸载
  end

  return res;
end

function biugomanager:Update(timespan)
  local maskcount = #self.masksequence;
  for i = 1, maskcount do
    self.masksequence[i]:Update(timespan);
  end
end

--对外接口，设置mask texture
--[[
function biugomanager:SetMaskVideoTexture(id,texid,size)
  local maskcount = #self.masksequence;
  for i = 1, maskcount do
    self.masksequence[i]:SetMaskTexture(id,texid,size);
  end
end
--]]

function biugomanager:SetMaskVideoTexture(texid,size)
  local maskcount = #self.masksequence;
  for i = 1, maskcount do
    self.masksequence[i]:SetMaskTexture(texid,size);
  end
end



function biugomanager:ReleaseResource()
  self.masksequence = {};
end


return biugomanager;