#include "docs:/facecute/material/shaders/functions/lut.function"



#SHADER_DEFINE MaskVideoVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 		HIGH,	VEC4,	"in_Position" },
    { ATTRIBUTE_COORDNATE0,			MEDIUM,	VEC2,		"in_Coordinate" },
	}
	FUNCTION_OUTPUT =
	{
    { ATTRIBUTE_COORDNATE0,		MEDIUM,	VEC2,		"Out_Coordinate1" },
    { MASK_COORNIDATE,			  MEDIUM,	VEC2,		"Out_Coordinate2" },
	}

#SHADER_CODE	
    gl_Position = in_Position;
    mediump vec2 Out_Coordinate1 = in_Coordinate;
    mediump float x = (in_Position.x + 1.0) / 2.0;
    mediump float y = 1.0 - (in_Position.y + 1.0) / 2.0;
    mediump vec2 Out_Coordinate2 = vec2(x,y);
#END_CODE
#END_DEFINE

#SHADER_DEFINE MaskBackgroundBlitClip_Vertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 		HIGH,	VEC4,	"in_Position" },
    { ATTRIBUTE_COORDNATE0,			MEDIUM,	VEC2,		"in_Coordinate" },
    { VERTEX_SCALER,            HIGH,   VEC2,   "in_VertexScaler" },
	}
	FUNCTION_OUTPUT =
	{
    { ATTRIBUTE_COORDNATE0,		MEDIUM,	VEC2,		"Out_Coordinate" },
	}

#SHADER_CODE	
    vec2 vertex_xy = vec2(in_Position.xy);
    vertex_xy = vertex_xy * in_VertexScaler;
    gl_Position = vec4(vertex_xy.x,vertex_xy.y,0.0,1.0);
    mediump vec2 Out_Coordinate = in_Coordinate;
#END_CODE
#END_DEFINE

#SHADER_DEFINE Cover_Vertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 		HIGH,	VEC4,	"in_Position" },
    { VERTEX_SCALER,            HIGH,   VEC2,   "in_VertexScaler" },
	}
	FUNCTION_OUTPUT =
	{
   
	}

#SHADER_CODE	
    vec2 vertex_xy = vec2(in_Position.xy);
    vertex_xy = vertex_xy * in_VertexScaler;
    gl_Position = vec4(vertex_xy.x,vertex_xy.y,0.0,1.0);
#END_CODE
#END_DEFINE

#SHADER_DEFINE CoverBase_Vertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 		HIGH,	VEC4,	"in_Position" },
    { ATTRIBUTE_COORDNATE0,			MEDIUM,	VEC2,		"in_Coordinate" },
	}
	FUNCTION_OUTPUT =
	{
    { ATTRIBUTE_COORDNATE0,		MEDIUM,	VEC2,		"Out_Coordinate1" },
	}

#SHADER_CODE	
    gl_Position = in_Position;
    mediump vec2 Out_Coordinate1 = in_Coordinate;
#END_CODE
#END_DEFINE


#SHADER_DEFINE MaskVideoFragment

	FUNCTION_INPUT = 
	{
    { MASK_TEXTURE,       NONE, TEXTURE2D,   "in_MaskTexture" },
    { CUSTOM_TEXTURE,     NONE, TEXTURE2D,   "in_CustomTexture" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate1" },
    { MASK_COORNIDATE,			  MEDIUM,	VEC2,		"in_Coordinate2" },
    { MASK_CHANNEL,           MEDIUM, VEC3,   "in_ChannelMask"},
    { MASK_LOCATION,          HIGH, FLOAT,   "in_MaskLocation"},
    { UV_SCALER,              HIGH, VEC2,    "in_UVScaler"},
	}
  FUNCTION_OUTPUT =
  {
  }
#SHADER_CODE

  highp vec2 uvCoordinate = (in_Coordinate1 - vec2(0.5,0.5)) * in_UVScaler + vec2(0.5,0.5);
  highp vec4 custom = texture2D(in_CustomTexture, uvCoordinate);
  highp vec4 mask = texture2D(in_MaskTexture, vec2(in_Coordinate2.x,in_Coordinate2.y));
  float maskV = mask.b * in_ChannelMask.r + mask.g * in_ChannelMask.g + mask.r * in_ChannelMask.b;
  gl_FragColor = vec4(custom.xyz,maskV * custom.a);
  //gl_FragColor = vec4(custom.xyz,1.0);
  //gl_FragColor = vec4(mask.xyz,1.0);
  //gl_FragColor = vec4(1.0,0.0,0.0,1.0);
#END_CODE
#END_DEFINE



#SHADER_DEFINE MaskVideoFragment_Version2

	FUNCTION_INPUT = 
	{
    { MASK_TEXTURE,       NONE, TEXTURE2D,   "in_MaskTexture" },
    { CUSTOM_TEXTURE,     NONE, TEXTURE2D,   "in_CustomTexture" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate1" },
    { MASK_COORNIDATE,			  MEDIUM,	VEC2,		"in_Coordinate2" },
    { MASK_CHANNEL,           MEDIUM, VEC3,   "in_ChannelMask"},
    { MASK_LOCATION,          MEDIUM, FLOAT,   "in_MaskLocation"},

	}
  FUNCTION_OUTPUT =
  {
  }
#SHADER_CODE

  mediump vec4 custom = texture2D(in_CustomTexture, in_Coordinate1);
  mediump float maskTexCoordX = in_MaskLocation / 3.0 + in_Coordinate2.x / 3.0;
  mediump vec4 mask = texture2D(in_MaskTexture, vec2(maskTexCoordX,in_Coordinate2.y));
  mediump float maskV = mask.r;
  gl_FragColor = vec4(custom.xyz,maskV * custom.a);
  //gl_FragColor = vec4(custom.xyz,1.0);
  //gl_FragColor = vec4(mask.xyz,1.0);
  //gl_FragColor = vec4(1.0,0.0,0.0,1.0);
#END_CODE
#END_DEFINE

#SHADER_DEFINE MaskVideoFragment_Version3

	FUNCTION_INPUT = 
	{
    { MASK_TEXTURE,       NONE, TEXTURE2D,   "in_MaskTexture" },
    { CUSTOM_TEXTURE,     NONE, TEXTURE2D,   "in_CustomTexture" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate1" },
    { MASK_COORNIDATE,			  MEDIUM,	VEC2,		"in_Coordinate2" },
    { MASK_CHANNEL,           MEDIUM, VEC3,   "in_ChannelMask"},
    { MASK_LOCATION,          HIGH, FLOAT,   "in_MaskLocation"},
    { LUT_TEXTURE,        NONE, TEXTURE2D,    "in_LutTexture"},
	}
  FUNCTION_OUTPUT =
  {
  }
#SHADER_CODE

  highp vec4 custom = texture2D(in_CustomTexture, in_Coordinate1);
  highp vec4 custom_color_lut = LUT(custom,in_LutTexture);
  highp vec4 mask = texture2D(in_MaskTexture, vec2(in_Coordinate2.x,in_Coordinate2.y));
  float maskV = mask.b * in_ChannelMask.r + mask.g * in_ChannelMask.g + mask.r * in_ChannelMask.b;
  gl_FragColor = vec4(custom_color_lut.xyz,maskV * custom_color_lut.a);
  //gl_FragColor = vec4(custom.xyz,1.0);
  //gl_FragColor = vec4(mask.xyz,1.0);
  //gl_FragColor = vec4(1.0,0.0,0.0,1.0);
#END_CODE
#END_DEFINE

#SHADER_DEFINE MaskBackgroundBlitClip_ZeroAlpha_Fragment
	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate" },
	}
  FUNCTION_OUTPUT =
  {
  }
#SHADER_CODE
  vec4 sampleColor = texture2D(in_DiffuseTexture,in_Coordinate);
  gl_FragColor = vec4(sampleColor.xyz,1.0);
  //gl_FragColor = texture2D(in_DiffuseTexture,in_Coordinate);
#END_CODE
#END_DEFINE

#SHADER_DEFINE MaskBackgroundBlitClip_Fragment
	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate" },
	}
  FUNCTION_OUTPUT =
  {
  }
#SHADER_CODE
  gl_FragColor = texture2D(in_DiffuseTexture,in_Coordinate);
#END_CODE
#END_DEFINE

#SHADER_DEFINE Cover_Fragment
	FUNCTION_INPUT = 
	{
    { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate" },
	}
  FUNCTION_OUTPUT =
  {
  }
#SHADER_CODE
  gl_FragColor = texture2D(in_DiffuseTexture,in_Coordinate);
#END_CODE
#END_DEFINE

#SHADER_DEFINE CoverBackground_Fragment
	FUNCTION_INPUT = 
	{
	}
  FUNCTION_OUTPUT =
  {
  }
#SHADER_CODE
  gl_FragColor = vec4(0.0,0.0,0.0,1.0);
#END_CODE
#END_DEFINE

#SHADER_DEFINE CoverBefore_Fragment
	FUNCTION_INPUT = 
	{
	}
  FUNCTION_OUTPUT =
  {
  }
#SHADER_CODE
  gl_FragColor = vec4(0.0,0.0,0.0,0.0);
#END_CODE
#END_DEFINE

#SHADER_DEFINE FadeInOutVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 		HIGH,	VEC4,	"in_Position" },
    { ATTRIBUTE_COORDNATE0,			MEDIUM,	VEC2,		"in_Coordinate" },
	}
	FUNCTION_OUTPUT =
	{
    { ATTRIBUTE_COORDNATE0,		MEDIUM,	VEC2,		"Out_Coordinate1" },
	}

#SHADER_CODE	
    gl_Position = in_Position;
    mediump vec2 Out_Coordinate1 = in_Coordinate;
#END_CODE
#END_DEFINE

#SHADER_DEFINE FadeInOutFragment

	FUNCTION_INPUT = 
	{
    { LYRIC_TEXTURE,     NONE, TEXTURE2D,   "in_LyricTexture" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate1" },
    { FADE_PROGRESS,        MEDIUM, FLOAT,  "in_FadeProgress"},
	}
  FUNCTION_OUTPUT =
  {
  }
#SHADER_CODE

  mediump vec4 lyric = texture2D(in_LyricTexture,in_Coordinate1);
  gl_FragColor = vec4(lyric.rgb * in_FadeProgress,lyric.a);
#END_CODE
#END_DEFINE


