//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in
//	all copies or substantial portions of the Software. And the logo of
//	Bohge Engine shall be displayed full screen for more than 3 seconds
//	when the software is started. Copyright holders are allowed to develop
//	game edit based on Bohge Engine, The edit must be released under the MIT
//	open source license if it is going to be published. In no event shall
//	copyright holders be prohibited from using any code of Bohge Engine
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////


#SHADER_DEFINE TransferVertex
    FUNCTION_INPUT =
    {
        { CAMERA_VIEWPROJ,            HIGH,    MAT4,        "in_ViewPorj" },
        { LOCALWORLD_TRANSFORM,       HIGH,    MAT4,        "in_Transfrom" },
        { ATTRIBUTE_POSITION,         HIGH,    VEC4,        "in_Position" },
				{ ATTRIBUTE_COORDNATE0,				MEDIUM,		VEC2,				"in_Coordinate"},

    }
    FUNCTION_OUTPUT =
    {
        { SCREENSPACE_POSITION,     HIGH,    VEC4,        "in_ScreenPosition" },
				{ ATTRIBUTE_COORDNATE0,			MEDIUM,	VEC2,					"out_Coordinate" },
    }
#SHADER_CODE
    vec4 in_ScreenPosition  = in_ViewPorj * in_Transfrom * in_Position;
		mediump vec4 new_Coordinate = in_ViewPorj * in_Transfrom * vec4(in_Coordinate,0,1);
		mediump vec2 out_Coordinate = (new_Coordinate.xy/new_Coordinate.w+vec2(1.0,1.0))/2.0;

		gl_Position = in_ScreenPosition;

#END_CODE
#END_DEFINE


#SHADER_DEFINE Transfer_FragmentOutput

	FUNCTION_INPUT =
	{
			{ TEXTURE_DIFFUSE,		  		NONE,			TEXTURE2D,	"in_Texture" },
		  { SCREENSPACE_POSITION,     HIGH,   	VEC4,    		"in_ScreenPosition" },
			{ ATTRIBUTE_COORDNATE0,			MEDIUM,		VEC2,				"in_Coordinate" },

	}
	FUNCTION_OUTPUT =
	{

	}

#SHADER_CODE
	//in_Coordinate.y = 1.0-in_Coordinate.y;
	clamp(in_Coordinate,0,1);
	gl_FragColor = vec4(texture2D(in_Texture, in_Coordinate).rgb, 1.0);
#END_CODE
#END_DEFINE
