#SHADER_DEFINE Sticker2drectVertex

	FUNCTION_INPUT = 
	{
  	{ LOCALSCREEN_TRANSVIEWPROJ,	HIGH,	MAT4,		"in_WorldViewPorj" },
		{ ATTRIBUTE_POSITION, 			  HIGH,	VEC4,		"in_Position" },
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
	}

	FUNCTION_OUTPUT = 
	{
    { ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position =in_WorldViewPorj*in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;
#END_CODE
#END_DEFINE


#SHADER_DEFINE Sticker2drectFragment

	FUNCTION_INPUT = 
	{
    { TEXTURE_DIFFUSE, 		  NONE,	TEXTURE2D,	"in_TextureFace" },
		{ ATTRIBUTE_COORDNATE0,	HIGH,	VEC2,		  "in_TexC" },    
	
	}
	
#SHADER_CODE
    vec3 rgb;
    float posAlpha = texture2D(in_TextureFace, in_TexC).a;
    rgb = texture2D(in_TextureFace, in_TexC).rgb;
    gl_FragColor = vec4(rgb, posAlpha);
#END_CODE
#END_DEFINE

#SHADER_DEFINE Sticker2drectFragment_Split

	FUNCTION_INPUT = 
	{
    { TEXTURE_DIFFUSE_RGB,  NONE, TEXTURE2D,  "in_TextureFaceRGB"},
    { TEXTURE_DIFFUSE_ALPHA,NONE, TEXTURE2D,  "in_TextureFaceAlpha"},
		{ ATTRIBUTE_COORDNATE0,	HIGH,	VEC2,		  "in_TexC" },    
	
	}
	
#SHADER_CODE
    vec3 rgb;
    float posAlpha = texture2D(in_TextureFaceAlpha, in_TexC).r;
    rgb = texture2D(in_TextureFaceRGB, in_TexC).rgb;
    gl_FragColor = vec4(rgb, posAlpha);
#END_CODE
#END_DEFINE