#SHADER_DEFINE Sticker2dmatVertex

	FUNCTION_INPUT = 
	{
  	{ UNIFORM_MATMVP,	HIGH,	MAT4,		"in_WorldViewPorj" },
    { UNIFORM_CUSTOMER_DEPTH,	HIGH,	FLOAT,		"in_Customer_Depth" },
		{ ATTRIBUTE_POSITION, 			  HIGH,	VEC4,		"in_Position" },
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
    { ATTRIBUTE_SCREENBGPOS, 		HIGH,	VEC2,		"in_ScrBgPos"},
    {UNIFORM_POSOFFSET,HIGH,	VEC2,		"in_PosOffset"},
    
	}

	FUNCTION_OUTPUT = 
	{
    { ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
    { ATTRIBUTE_SCREENBGPOS,			HIGH,	VEC2,		"out_SrcBgPos" },
	}

#SHADER_CODE

    mat4 umat =mat4(1.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,  0.0,0.0,1.0,0.0,  0.0,0.0,0.0,1.0);
    vec4 rotpos = in_WorldViewPorj*in_Position;
    //gl_Position = vec4(rotpos.xy, in_Customer_Depth*rotpos.w, rotpos.w);
    gl_Position = vec4(rotpos.xy+in_PosOffset*rotpos.w, in_Customer_Depth*rotpos.w, rotpos.w);
    vec2 out_TexCooridate = in_TexCooridate.xy;
    vec2 out_SrcBgPos;
    out_SrcBgPos = (rotpos.xy/rotpos.w+vec2(1.0,1.0))/2.0;
    out_SrcBgPos.y =1.0-out_SrcBgPos.y;
#END_CODE
#END_DEFINE
#SHADER_DEFINE Sticker2dmatFragment
	FUNCTION_INPUT = 
	{
    { TEXTURE_DIFFUSE, 		  NONE,	TEXTURE2D,	"in_TextureFace" },
		{ ATTRIBUTE_COORDNATE0,	HIGH,	VEC2,		  "in_TexC" }, 
    { TEXTURE_DIFFUSE_BGALPHA, 		  NONE,	TEXTURE2D,	"in_TextureBgAlpha" },
    { ATTRIBUTE_SCREENBGPOS,	HIGH,	VEC2,		  "in_TexBgPos" }, 
	
	}
#SHADER_CODE
    vec3 rgb;
    float posAlpha = texture2D(in_TextureFace, in_TexC).a;
    float bgAlpha = 1.0-texture2D(in_TextureBgAlpha, in_TexBgPos).r;
    rgb = texture2D(in_TextureFace, in_TexC).rgb;
    //gl_FragColor=vec4(vec3(1.0,1.0,1.0)-texture2D(in_TextureBgAlpha, in_TexBgPos).rgb,1.0);
    //gl_FragColor = vec4(rgb*posAlpha*bgAlpha, posAlpha*bgAlpha);
    //gl_FragColor = vec4(rgb*posAlpha, posAlpha);
      gl_FragColor = vec4(rgb*posAlpha*bgAlpha, posAlpha*bgAlpha);
#END_CODE
#END_DEFINE

#SHADER_DEFINE Sticker2dmatFragment_Split
	FUNCTION_INPUT = 
	{
    { TEXTURE_DIFFUSE, 		  NONE,	TEXTURE2D,	"in_TextureFace" },
    { TEXTURE_DIFFUSE_RGB,  NONE, TEXTURE2D,  "in_TextureFaceRGB"},
    { TEXTURE_DIFFUSE_ALPHA,NONE, TEXTURE2D,  "in_TextureFaceAlpha"},
		{ ATTRIBUTE_COORDNATE0,	HIGH,	VEC2,		  "in_TexC" }, 
      { TEXTURE_DIFFUSE_BGALPHA, 		  NONE,	TEXTURE2D,	"in_TextureBgAlpha" },
        { ATTRIBUTE_SCREENBGPOS,	HIGH,	VEC2,		  "in_TexBgPos" }, 
	
	}
#SHADER_CODE
    vec3 rgb;
    float posAlpha = texture2D(in_TextureFaceAlpha, in_TexC).r;
    rgb = texture2D(in_TextureFaceRGB,in_TexC).rgb;
     float bgAlpha = 1.0-texture2D(in_TextureBgAlpha, in_TexBgPos).r;
    //gl_FragColor = vec4(rgb*posAlpha, posAlpha);
    gl_FragColor = vec4(rgb*posAlpha*bgAlpha, posAlpha*bgAlpha);

#END_CODE
#END_DEFINE