local SequenceAnimation = require "apolloutility.sequenceanimation"
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local Faceinfo = require "videodecet.faceinfo";
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local likeapp = require "likeapp"
local mlsofa = require "mlsofa"



local maxfacecount = 3;
local keypointcount = 106;
local videodecet = {}
setmetatable(videodecet, basedetect);

function videodecet:Initialize(imagedoc, imagefile, pointfile)
  self.newframecallback = {}
  
  apolloengine.IGraphicSystem:Pointsize(4);
  apolloengine.ShaderEntity.POINT_COLOR = 
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "POINT_COLOR");
    
  self.animation = SequenceAnimation(defiend.blit_material_path);
  renderqueue:Prev(self.animation)
  
  self.animation:Play(imagedoc, imagefile, nil, 30, true, 1, true);
  
  self.sofa = mlsofa.SofaShell();
  self.sofa:SetMaxDetectFaces(maxfacecount);
  
  self.actioninfos = {}
  self.pointrenders = {}  
  for i=1, maxfacecount do
    local pr = apollonode.PointNode();
    pr:CreateResource(
      keypointcount,
      mathfunction.vector4(0,1,0,1),
      "comm:documents/material/pointrender.material");
    pr:SetShow(false);
    renderqueue:Prev(pr);
    table.insert(self.pointrenders, pr);
  end
end

function videodecet:ShowKeypoint(isshow)
  
end

function videodecet:AddNewframeCallback(func)
  table.insert(self.newframecallback, func);
end

function videodecet:Update(def)
  local _, frame = self.animation:Update(def);
  if self.frameindex ~= frame then
    self.faces = {}
    self.actioninfos = {{},{},{}};
    self.frameindex = frame;    
    local rgb = self.animation:GetCurrentTexture();
    local imagesize = rgb:GetSize();
    local testvidesize = {imagesize:x(), imagesize:y()};
    local stream = rgb:GetSourceStream();
    self.sofa:Update(stream);
    local count = self.sofa:GetFaceCount();
    for i=1, count do
      local landmark = self.sofa:GetLandmark(i);
      local pry = self.sofa:GetAngular(i);
      local action = self.sofa:GetAction(i);
      local fi = Faceinfo(testvidesize);
      for i=1, #landmark, 2 do
        fi:PushKeypoint(landmark[i], landmark[i+1]);
      end      
      fi:PushRotation(pry[1], pry[2], pry[3])
      table.insert(self.faces, fi);
    end
    
    if self.faces then
      for i=1, #self.pointrenders do
        local pr = self.pointrenders[i];
        local fi = self.faces[i];
        if fi then
          pr:SetShow(true);
          pr:Update(fi:GetKeypointArray());
        else
          pr:SetShow(false);
        end    
      end  
    end
    for _, func in ipairs(self.newframecallback) do
      func();
    end
    return true;
  end
  return false;
end

function videodecet:SetTexture(tex)
end

--得到当前的人脸信息
function videodecet:GetFaces()
  return self.faces;
end

--得到当前的视屏纹理
function videodecet:GetVideoTexture()
  return self.animation:GetCurrentTexture();
end

function videodecet:ActiveActions(actions)
  likeapp.AI:ActiveActions(actions)
end

function videodecet:GetActions()
  return self.actioninfos;
end

return videodecet;