local SequenceAnimation = require "apolloutility.sequenceanimation"
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local Faceinfo = require "videodecet.faceinfo";
local Actioninfo = require "videodecet.actioninfo";
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local likeapp = require "likeapp"



local maxfacecount = 3;
local keypointcount = 106;
local testvidesize = {720, 1280}

local videodecet = {}
setmetatable(videodecet, basedetect);

function videodecet:Initialize(imagedoc, imagefile, pointfile)

  self.isShowDebugPoint = true ;

  --新帧回调
  self.newframecallback = {}
  setmetatable(self.newframecallback, {__mode = "v"})
  
  apolloengine.IGraphicSystem:Pointsize(4);
  apolloengine.ShaderEntity.POINT_COLOR = 
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "POINT_COLOR");
    
  self.animation = SequenceAnimation(defiend.blit_material_path);
  --self.animation:SetShow(false);
  renderqueue:Prev(self.animation)
  
  self.animation:Play(imagedoc, imagefile, nil, 30, true, 1);

  --创建解析服务
  self.paserservice = venuscore.IServicesSystem:Create("videodecet.paserservice_action");

  self.pointrenders = {}
  local keypointcount = self.paserservice:GetKeyPointCount();
  
  for i=1, maxfacecount do
    local pr = apollonode.PointNode();
    pr:CreateResource(
      keypointcount,
      mathfunction.vector4(0,1,0,1),
      "comm:documents/material/pointrender.material");
    pr:SetShow(false);
    renderqueue:Prev(pr);
    table.insert(self.pointrenders, pr);
  end
  
  --动作信息
  self.actioninfos = {}
  
  --解析关键点
  self.frameindex = 0;
  self.faceframes = {}
  self.insertfunction = function (fdatas, adatas)
    local faces = {};
    for _, d in ipairs(fdatas) do
      local fi = Faceinfo:as(d);
      table.insert(faces, fi);
    end    
    table.insert(self.faceframes, faces);
    --动作
    local pepole = {};--camera和android每个人可能有多个动作，这里模拟一下
    local actions = {};
    table.insert(pepole, actions);
    for _, d in ipairs(adatas) do
      local ai = Actioninfo:as(d);
      table.insert(actions, ai);
    end    
    table.insert(self.actioninfos, pepole);    
    return true;
  end
  local agent, index = g_callbackhandle:RegisterCallback(self.insertfunction);
  local fullpath = venuscore.IFileSystem:PathAssembly(imagedoc..pointfile);
  self.paserservice:PaserFile(agent, index, testvidesize, fullpath);  
end

function videodecet:ShowKeypoint(isshow)
  
end

function videodecet:AddNewframeCallback(func)
  table.insert(self.newframecallback, func);
end

function videodecet:Update(def)
  local _, frame = self.animation:Update(def);
  if self.frameindex ~= frame then
    self.frameindex = frame;
    local faces = self.faceframes[frame];
    if faces  and self.isShowDebugPoint  then
      for i=1, #self.pointrenders do
        local pr = self.pointrenders[i];
        local fi = faces[i];
        if fi then
          pr:SetShow(true);
          pr:Update(fi:GetKeypointArray());
        else
          pr:SetShow(false);
        end
      end
    else
      for i=1, #self.pointrenders do
        local pr = self.pointrenders[i];
        pr:SetShow(false);
      end
    end
    for _, func in ipairs(self.newframecallback) do
      func();
    end
    return true;
  end
  return false;
end

function videodecet:SetTexture(tex)
end

--得到当前的人脸信息
function videodecet:GetFaces()
  return self.faceframes[self.frameindex];
end

function videodecet:UpdateKeypoints(idx,keypoint)
  self.faceframes[self.frameindex][idx]:UpdateKeypoints(keypoint);
end

function videodecet:resetDetectFlag()
  -- 暂时没有需要
end

function videodecet:GetActions()
  return self.actioninfos[self.frameindex];
end

function videodecet:ActiveActions(actions)
  likeapp.AI:ActiveActions(actions)
end

--得到当前的视屏纹理
function videodecet:GetVideoTexture()
  return self.animation:GetCurrentTexture();
end

function videodecet:SetShow(isShow)
  self.animation:SetShow(isShow);
end

function videodecet:SetDebugPointShow(isShow)
  self.isShowDebugPoint = isShow ;
end

function videodecet:PushNewFaceLandMark()
  local newFaceLandMarks = {};
  local index = 1 ;
  local faces = self:GetFaces();
  for _, face in pairs(faces) do
    local keypointArray = face:GetKeypointArray();
    for _, one in pairs(keypointArray) do
      local x, y = face:toAbsoluteCoordinates(one);
      newFaceLandMarks[index]   = x;
      newFaceLandMarks[index+1] = y;
      index = index + 2 ;
    end
  end
  likeapp.AI:PushNewFaceLandMark(newFaceLandMarks);
end

return videodecet;
