local SequenceAnimation = require "apolloutility.sequenceanimation"
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local Faceinfo = require "videodecet.faceinfo";
local Actioninfo = require "videodecet.actioninfo";
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local faceseg = require "videodecet.faceseg"
local videocapture = require "videocapture"
local venuscore = require "venuscore"
local likeapp = require "likeapp"
local mlsofa = require "mlsofa"
--local mlcnnseg = require "mlcnnseg"
local videodefined = require"videodecet.defined"
local vc = require "venuscore"
local cnnseg = require "videodecet.cnnseg"
local maxfacecount = 3;
local keypointcount = 106;
local videodecet = {}
local bitop = require "bit"
setmetatable(videodecet, basedetect);
  

function videodecet:TryOpenCamera()
  if not self.capture then
    self.capture = videocapture.AsyncVideoCapture();
    local resolution = apolloengine.Framework:GetResolution();
    self.capture:open(resolution, 0);
    if self.capture:isOpened() then
      return true;
    end
    ERROR("fail to open the camera!");
    return false;
  end
  return self.capture:isOpened();
end

function videodecet:Initialize(imagedoc, imagefile, pointfile)

  self.detectHandClassify = false ;
  self.isShowDebugPoint = true ;

  --新帧回调
  self.newframecallback = {}
  setmetatable(self.newframecallback, {__mode = "v"})
  
  apolloengine.IGraphicSystem:Pointsize(4);
  apolloengine.ShaderEntity.POINT_COLOR = 
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "POINT_COLOR");
    
  self.yuv_ts = self.capture:read();
  local asize = self.yuv_ts:GetSize();
  self.size = {asize:x(), asize:y()};
  self.capturetexture = apolloengine.TextureEntity();
  self.capturetexture:PushMetadata(
    apolloengine.TextureBufferMetadata(
      apolloengine.TextureEntity.TU_WRITE,
      1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      self.yuv_ts));
  self.capturetexture:CreateResource();
  self.render = apollonode.QuadNode();
  self.render:CreateResource(defiend.blit_material_path, false);
  self.render:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.capturetexture);

  renderqueue:Prev(self.render);
  
  self.sofa = mlsofa.SofaShell();
  self.sofa:SetMaxDetectFaces(maxfacecount);
  self.sofa:SetEnableDynamicExpression(true);
  

  self.actioninfos = {}
  self.pointrenders = {}  
  for i=1, maxfacecount do
    local pr = apollonode.PointNode();
    pr:CreateResource(
      keypointcount,
      mathfunction.vector4(0,1,0,1),
      "comm:documents/material/pointrender.material");
    pr:SetShow(false);
    renderqueue:Prev(pr);
    table.insert(self.pointrenders, pr);
  end
  self.cnnSegMark  =false;
end



function videodecet:ShowKeypoint(isshow)
  
end

function videodecet:SetCnnSegMark(mark)
  self.cnnSegMark = mark;
  cnnseg:SetCnnSegMark(mark);
end

function videodecet:AddNewframeCallback(func)
  table.insert(self.newframecallback, func);
end


function videodecet:Update(def)
  if self.capture:hasNextFrame() then
    self.faces = {}
    self.actioninfos = {}
    self.yuv_ts = self.capture:read();
    self.capturetexture:SubstituteTextureBuffer(self.yuv_ts);
    self.sofa:Update(self.yuv_ts);

    --if(not cnnseg:IsInitialize())
   -- then
     -- cnnseg:Initialize(self.size[1], self.size[2]);
    --end
  
 
     
    --if(self.cnnSegMark)
    --then
      --cnnseg:Update(ts,def);
    --end
    faceseg:Initialize(self.size[1], self.size[2]);
    faceseg:Update(self.yuv_ts,def);

    local count = self.sofa:GetFaceCount();
    for i=1, count do
      local landmark = self.sofa:GetLandmark(i);
      local pry = self.sofa:GetAngular(i);
      local fi = Faceinfo(self.size);
      for i=1, #landmark, 2 do
        fi:PushKeypoint(landmark[i], landmark[i+1]);
      end      
      fi:PushRotation(pry[1], pry[2], pry[3])
      table.insert(self.faces, fi);
      
      --更新动作
      local actions = {}
      table.insert(self.actioninfos, actions);
      local rect = self.sofa:GetRect(i);
      local rawarray = self.sofa:GetAction(i);
      for _, aid in ipairs(rawarray) do
        local ai = Actioninfo(self.size);
        ai:PushActionID(aid);
        ai:PushCenter((rect[1] + rect[3]) / 2, (rect[2] + rect[4]) / 2);
        ai:PushRect(rect[1], rect[2], rect[3], rect[4]);
        table.insert(actions, ai);
      end
    end
    -- 如果需要手势分类 设置手势动作
    if self:NeedHandDetect() then
      local handData = faceseg:GetSegKeypointArray(videodefined.detectType.HandClassify)
      if handData ~= nil and handData:Size() > 1 then -- Size==1 只有头部,代表没有有效手势
        local header  = handData:Get(1);
        local handNums = header:x();
        --LOG("handNums "..handNums)
        if( (handData:Size()-1) == handNums * 4 ) then

          local personID = 1

          for i = 2, handNums*4 , 4 do

            local actions = self.actioninfos[personID]; -- bvt不区分人 暂时把手势分布在各个人动作中
            if actions == nil then
              actions = {}
              table.insert(self.actioninfos, actions);
            end
            personID = personID + 1 ;


            local handinfo = handData:Get( i );
            local handId = handinfo:x();
            local handAction = handinfo:y();
            local handRectXY = handData:Get( i + 1 );
            local handRectWH  = handData:Get( i + 2 );
            local handCenterXY = handData:Get( i + 3 );
            --LOG("handId "..handId..";handAction "..handAction)
            --LOG("handRectXY "..handRectXY:x().." "..handRectXY:y());
            --LOG("handRectWH "..handRectWH:x().." "..handRectWH:y());
            --LOG("handCenterXY "..handCenterXY:x().." "..handCenterXY:y());

            local ai = Actioninfo(self.size);
            ai:PushActionID(handAction);
            ai:PushCenter( handCenterXY:x(), handCenterXY:y() );
            ai:PushRect( handRectXY:x(), handRectXY:y(), handRectXY:x()+handRectWH:x(), handRectXY:y()+handRectWH:y());
            table.insert(actions, ai);

          end
        else
          ERROR("Size Not Match handNums="..tostring(handNums).." handData="..tostring(handData:Size()))
        end
      --elseif handData ~= nil then
      --  WARNING("HandSize is  "..handData:Size() );
      end

    end


    if self.faces and self.isShowDebugPoint then
      for i=1, #self.pointrenders do
        local pr = self.pointrenders[i];
        local fi = self.faces[i];
        if fi then
          pr:SetShow(true);
          pr:Update(fi:GetKeypointArray());
        else
          pr:SetShow(false);
        end
      end
    else
      for i=1, #self.pointrenders do
      local pr = self.pointrenders[i];
      pr:SetShow(false);
    end
    end

    for _, func in ipairs(self.newframecallback) do
      func();
    end
    return true;
  end
  return false;
end

function videodecet:SetTexture(tex)
end

--得到当前的人脸信息
function videodecet:GetFaces()
  return self.faces;
end

function videodecet:GetPixelFacekeypointArray()
  local keypointarray = mathfunction.vector2array();
  local count = self.sofa:GetFaceCount();
  for i=1, count do
    local landmark = self.sofa:GetLandmark(i);
    for j=1, #landmark, 2 do
      keypointarray:PushBack(mathfunction.vector2(landmark[j], landmark[j+1]));
    end
  end
  return keypointarray;
end

--得到当前的视屏纹理
function videodecet:GetVideoTexture()
  return self.capturetexture;
end


function videodecet:NeedHandDetect()
  --LOG("video detect NeedHandDetect "..tostring(self.detectHandClassify) )
  return self.detectHandClassify ;
end

function videodecet:ActiveActions(actions)

  local newAction = {}
  for key, value in pairs(actions) do
    local handDetectFlag = bitop.band(value,videodefined.handActionType) ;
    if handDetectFlag ~= 0 then
      LOG("Hand Detect ON");
      self.detectHandClassify = true ;
      faceseg:SetSegMark(videodefined.detectType.HandClassify,true);
    else --过滤掉所有的手势动作
      table.insert(newAction,value);
    end
  end
  if #newAction ~= 0 then
    likeapp.AI:ActiveActions(newAction);
  else
    WARNING("ActiveActions actions filter none callback");
  end

end

--释放素材时候 清理所有的检测标记
function videodecet:resetDetectFlag()
  self.detectHandClassify = false ;
  faceseg:SetSegMark(videodefined.detectType.HandClassify,false);
end

function videodecet:GetActions()
  return self.actioninfos;
end

function videodecet:SetShow(isShow)
  if self.isShowBaseVideo ~= isShow then
    self.isShowBaseVideo = isShow;
    self.node:SetShow(isShow);
  end
end


function videodecet:SetDebugPointShow(isShow)
  self.isShowDebugPoint = isShow ;
end

function videodecet:GetVideoSize()
  return self.size;
end

function videodecet:GetVideoFrame()
  return self.yuv_ts;
end

function videodecet:PushNewFaceLandMark()
  local newFaceLandMarks = {};
  local index = 1 ;
  local faces = self:GetFaces();
  for _, face in pairs(faces) do
    local keypointArray = face:GetKeypointArray();
    for _, one in pairs(keypointArray) do
      local x, y = face:toAbsoluteCoordinates(one);
      newFaceLandMarks[index]   = x;
      newFaceLandMarks[index+1] = y;
      index = index + 2 ;
    end
  end
  likeapp.AI:PushNewFaceLandMark(newFaceLandMarks);
end

return videodecet;