
--[[local baseseg =require "videodecet.baseseg"
local facecnnseg= baseseg:extend();

function facecnnseg:new()
   facecnnseg.super.new(self); 
end
function facecnnseg:GetSegCls()
  local cnnsegcls=require"videodecet.androidcnnseg" ;
  return cnnsegcls;
end
return facecnnseg;]]
local Object = require "classic"
local facecnnseg= Object:extend();
function facecnnseg:GetSegCls()
  local cnnsegcls=require"videodecet.androidcnnseg" ;
  return cnnsegcls;
end

function facecnnseg:new()
  
local cnnsegcls = self:GetSegCls()
self.cnnsegment=cnnsegcls();
self.servicecallbacks = {};
self.serviceobjs={};
setmetatable(self.servicecallbacks, {__mode = "v"}) --弱引用 
setmetatable(self.serviceobjs, {__mode = "v"}) --弱引用 
self.cnnsegmark = false;
end

function facecnnseg:SetType(segType)
  self.segType = segType;
  self.cnnsegment:SetType(segType);
end


function facecnnseg:RegisterCnnSegJudgeFunc(obj,func)
  table.insert(self.servicecallbacks,func);
  table.insert(self.serviceobjs,obj);
end

function facecnnseg:Initialize(w,h)
  if(not self.cnnsegmark)
  then
    return;
  end
  --cnnsegment.cnnSegMark = true;
  if (self.cnnsegment.cnnsegInit == false) 
  then
     self.cnnsegment:InitCnnSeg(w, h);
  end
end


function facecnnseg:IsInitialize()
  return self.cnnsegment.cnnsegInit;
end

function facecnnseg:SetCnnSegMark(mark)
   self.cnnsegmark = mark;
   self.cnnsegment.cnnSegMark = mark;
end


function facecnnseg:GetSegmentMark(mark)
  
   if(self.cnnsegmark==nil)
   then
     return false;
   else
     return self.cnnsegmark;
   end
 
end

function facecnnseg:Update(ts,def)

  if(not self.cnnsegmark)
  then
    return;
  end
  self.ts = ts;
  self.def =def;
  self.cnnsegment:startNewUpdate();
end

function facecnnseg:OnResizeView(w,h)
  
 --[[ if(not self.cnnsegmark)
  then
    return;
  end]]
  self.cnnsegment:OnResizeView(w,h);
end


function facecnnseg:RunSeg()
  
  if(not self.cnnsegmark)
  then
    return;
  end
  
  local len =#self.servicecallbacks;
  local res = false;
  for i=1,len do
    --if(servicecallbacks[i].NeedBackGroundSplit)
    if(self.servicecallbacks[i] and self.serviceobjs[i] )
    then
     -- res=servicecallbacks[i]:NeedBackGroundSplit();
     res =self.servicecallbacks[i](self.serviceobjs[i]);
    end
    if(res==true)
    then
      break;
    end
  end
  if(res==true)
  then
    self.cnnsegment:startNewUpdate();
    self:GetSegTexture();
  end
end

function facecnnseg:GetSegTexture()
  
  if(not self.cnnsegmark)
  then
    return nil;
  end
  
  if (self.cnnsegment.cnnsegInit == true) 
  then
    local ts = self.ts;
    local def = self.def;
    local cnnsegtexture = self.cnnsegment:Update(ts,def);
    return cnnsegtexture;
  end
  return nil;
  
end

return facecnnseg;