

local Object = require "classic"
local facecnndetect= Object:extend();

function facecnndetect:GetSegCls()
  local cnndetectcls = require "videodecet.mldetection" ;
  return cnndetectcls;
end

function facecnndetect:new()
  local cnndetectcls = self:GetSegCls()
  self.cnndetection = cnndetectcls();
  self.servicecallbacks = {};
  self.serviceobjs={};
  setmetatable(self.servicecallbacks, {__mode = "v"}) --弱引用 
  setmetatable(self.serviceobjs, {__mode = "v"}) --弱引用 
  self.cnndetectmark = false;
end


function facecnndetect:SetType(segType)
  self.segType = segType;
  self.cnndetection:SetType(segType);
end


function facecnndetect:RegisterCnnSegJudgeFunc(obj,func)
  table.insert(self.servicecallbacks,func);
  table.insert(self.serviceobjs,obj);
end

function facecnndetect:Initialize(w,h)
  if(not self.cnndetectmark) then
    ERROR("facecnndetect:Initialize cnndetectmark is false")
    return;
  end
  
  if (self.cnndetection.DetectInit == false) then
    self.cnndetection:InitCnnDetection(w, h);
  end
end


function facecnndetect:IsInitialize()
  return self.cnndetection.DetectInit;
end

function facecnndetect:SetCnnSegMark(mark)
   self.cnndetectmark = mark;
   self.cnndetection.detectMark = mark;
end


function facecnndetect:GetSegmentMark(mark)
  
  if(self.cnndetectmark == nil) then
    return false;
  else
    return self.cnndetectmark;
  end
 
end

function facecnndetect:Update(ts,def)

  if(not self.cnndetectmark) then
    return;
  end
  self.ts = ts;
  self.def =def;
  self.cnndetection:startNewUpdate();
end

function facecnndetect:OnResizeView(w,h)
  self.cnndetection:OnResizeView(w,h);
end


function facecnndetect:RunSeg()
  if(not self.cnndetectmark) then
    return;
  end
  
  local len =#self.servicecallbacks;
  local res = false;
  for i=1,len do
    if(self.servicecallbacks[i] and self.serviceobjs[i] ) then
     res =self.servicecallbacks[i](self.serviceobjs[i]);
    end
    if(res == true) then
      break;
    end
  end
  if(res == true) then
    self.cnndetection:startNewUpdate();
    self:GetSegKeypointArray();  --得到关键点
  end
end

function facecnndetect:GetSegKeypointArray()
  if (not self.cnndetectmark) then
    return nil;
  end
  
  if (self.cnndetection.DetectInit == true) then
    local ts = self.ts;
    local def = self.def;
    local pointarray = self.cnndetection:Update(ts,def);
    return pointarray;
  end
  return nil;
end


function facecnndetect:GetSegTexture()
  return nil;
end

return facecnndetect;