local Object = require "classic"
local cnnseg = Object:extend();
--local mlcnnseg = require "likeapp"
local videodefined = require"videodecet.defined"
local apolloengine = require "apolloengine"
local vc = require "venuscore"
local maskOutW = 128;
local mlcnnseg =nil;
local CnnSegShell = nil;
function cnnseg:SetCnnSegShell()
  if _PLATFORM_WINDOWS then
       mlcnnseg = require "mlcnnseg"
       CnnSegShell =mlcnnseg.CnnSegShell;
  else
      mlcnnseg = require "likeapp"
      CnnSegShell =mlcnnseg.UpperSegService;
  end
 
end

function cnnseg:new()
  self.cnnSegMark = false;
  self:initPara();
  self:SetCnnSegShell();
end
function cnnseg:initPara()
  self.w = 0;
  self.h = 0;
  self.cnnsegInit = false;
  self.cnnsegtexture = nil;
  self.cnnsegts = nil;
  self.lastdef = 0;
 -- self.cnnSegMark = false;
end

function cnnseg:InitCnnSeg( w, h)
  
  if( mlcnnseg==nil or CnnSegShell==nil)
  then 
    return;
  end
  self:initPara();
  self.cnnseg = CnnSegShell();
  if(self.cnnseg and CnnSegShell.SetType)
  then
    self.cnnseg:SetType(self.segType);
  end
  --self.tsPara=self.cnnseg:GetConstTexStream(4,4,0);
  --self.cnnseg:SetPowerSave(0);
  local r =self.cnnseg:Init(w,h,vc.IFileSystem:PathAssembly(videodefined.cnnseg_path..videodefined.cnnseg_modle_use));
  self.tsPara=self.cnnseg:GetConstTexStream(4,4,0);
  self.cnnseg:SetSpeedId(1);
  self.cnnseg:SetThreshold(-1);
  if(r~=videodefined.cnnsegFlag.SUCCESS)
  then
    self.cnnsegInit = false;
  else
    self.cnnsegInit = true;
    self.w = w;
    self.h = h;
  end
  
  self.cnnsegtexture = nil;
  --self.cnnsegts = self.cnnseg:GetConstTexStream(w,h,0);
  local num1,num2=math.modf(h*maskOutW/w/2);
  self.cnnsegts = self.cnnseg:GetConstTexStream(maskOutW,2*num1,0);
  self.cnnConstStream = self.cnnsegts;
  self.cnnsegtexture = apolloengine.TextureEntity();
  self.cnnsegtexture:PushMetadata(
  apolloengine.TextureBufferMetadata(
      apolloengine.TextureEntity.TU_WRITE,
      1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
       self.cnnsegts));
  self.cnnsegtexture:CreateResource();
    
end

function cnnseg:SetType(segType)
    self.segType = segType;
end

function cnnseg:startNewUpdate()
  
  if( mlcnnseg==nil or CnnSegShell==nil)
  then
    return;
  end
   --self.lastdef = -1;
   self.newupd = true;
end


function cnnseg:SetCnnSegMark(mark)
  if( mlcnnseg==nil or CnnSegShell==nil)
  then
    return;
  end
  self.cnnSegMark = mark;
  --self.cnnsegtexture=nil;
  --self.cnnsegts = nil;
end

function cnnseg:OnResizeView(w,h)
  if( mlcnnseg==nil or CnnSegShell==nil)
  then
    return;
  end
  if(self.w~=w or self.h~=h)
  then
    self.cnnsegInit = false;
    --self:InitCnnSeg(w,h);
  end
end

function cnnseg:Update(ts,def)
  
  if( mlcnnseg==nil or CnnSegShell==nil)
  then
    return nil;
  end
  self:_UpdateCnnSeg(ts,def);
  return self.cnnsegtexture;
end


function cnnseg:_UpdateCnnSeg(ts,def)
   
  if( mlcnnseg==nil or CnnSegShell==nil)
  then
    return;
  end
  
   if(not self.newupd)
   then
     return;
   end
  --[[ if(self.lastdef==def)
   then
     return;
   else
     self.lastdef = def;
   end]]
   
   if(not (self.cnnSegMark and self.cnnsegInit==true))
    then
      --self.cnnsegtexture = nil;
      --self.cnnsegts = nil;
      return;
    end
  local cnnsegts = nil; 
  if(ts==nil)
  then
    cnnsegts = self.cnnseg:Run(self.tsPara);
  else
    cnnsegts = self.cnnseg:Run(ts);
  end
  
  if(cnnsegts==nil)
  then
    return;
  end
  if(cnnsegts==nil)
  then
   return;
  end
  self.cnnsegts = cnnsegts;
  self.cnnsegtexture:SubstituteTextureBuffer(self.cnnsegts);
  self.newupd = false;
end

return cnnseg;