local venuscore = require "venuscore"
local cjson = require "cjson"
require "utility"

local venusjson = {}
local cachecount = 20;
local cachearray = {}
local keyqueue = {}


local function deepcopy(orig)
    local orig_type = type(orig)
    local copy
    if orig_type == 'table' then
        copy = {}
        for orig_key, orig_value in next, orig, nil do
            copy[deepcopy(orig_key)] = deepcopy(orig_value)
        end
        setmetatable(copy, deepcopy(getmetatable(orig)))
    else -- number, string, boolean, etc
        copy = orig
    end
    return copy
end

--加载指定位置的json文件返回table
function venusjson.LaodJsonFile(path)
  local res = cachearray[path];
  local lastmodif = venuscore.IFileSystem:GetTimestamp(path);
  if res then    
    if res.timestamp ~= lastmodif then
      res = nil;
    end
  end  
  if not res then
    res = {};
    if not venuscore.IFileSystem:isFileExist(path) then
      ERROR("json file:" .. path .. " not exist");
    else    
      local str = venuscore.IFileSystem:ReadFile(path);
      res.json = cjson.decode(str);
      res.timestamp = lastmodif;
      cachearray[path] = res;
      local size = #keyqueue;
      keyqueue[size + 1] = path;
      if size == cachecount then
        local rp = table.remove(keyqueue, 1);
        cachearray[rp] = nil;
      end      
    end
  end
  return deepcopy(res.json);
end

venusjson.LoadJsonFile = venusjson.LaodJsonFile

function venusjson.LoadJsonString(text)
    if text == nil then
        return nil
    end
    local json = cjson.decode(text)
    if json == nil then
        return nil
    end
    return deepcopy(json)
end

function venusjson.StoreJsonString(json)
    if json == nil then
        return nil
    end
    return cjson.encode(json)
end

function venusjson.SaveJsonObject(jtable, path)
  local sf, df, err, ok
  local function bail(...)
		if df then df:close() end
		return ...
	end
  local jstr = cjson.encode(jtable);
  df, err = io.open(path, "wb")
	if not df then return bail(nil, err) end
  ok, err = df:write(jstr)
  if not ok then return bail(nil, err) end
  return bail(true);
end

return venusjson;