local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local addblendfilter = {}
addblendfilter.Abf = 0;
addblendfilter.Queue = 115;

local imagePath = "comm:documents/material/background.jpg";
function addblendfilter:Initialize(host, size)
  self.tex = apolloengine.TextureEntity();
  self.tex:PushMetadata(apolloengine.TextureFileMetadata(
	  apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_BORDER,
      apolloengine.TextureEntity.TW_CLAMP_TO_BORDER,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      imagePath));
  self.tex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
  self.tex:CreateResource();
    --<!--  set the offsets parameters in vertex shader -->
  self.MIX_TEXTURE =apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"MIX_TEXTURE");
  self.AlPHA =apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"AlPHA");
  self.Abf = host:CreateRenderObject("comm:documents/filter/material/addblendfilter.material");
  self.Abf:SetParameter(self.MIX_TEXTURE, self.tex);
  self.Abf:SetParameter(self.AlPHA, mathfunction.vector1(0.4));
  --self:_SetParam(size);
  return self.Queue;
end

function addblendfilter:Resizeview(size)
  --self:_SetParam(size);
end

function addblendfilter:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Abf:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Abf:Draw(pipeline);
end

return addblendfilter;
