local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local rgbseperate = {}

rgbseperate.Queue = 320;

function rgbseperate:Initialize(host, size)
    self.WrapS = apolloengine.TextureEntity.TW_CLAMP_TO_BORDER;
    self.WrapT = apolloengine.TextureEntity.TW_CLAMP_TO_BORDER;

    self.UseBorder = mathfunction.vector2(1,1);

    self.ScaleR = mathfunction.vector2(1,1);
    self.ScaleG = mathfunction.vector2(1,1);
    self.ScaleB = mathfunction.vector2(1,1);

    self.OffsetR = mathfunction.vector2(0,0);
    self.OffsetG = mathfunction.vector2(0,0);
    self.OffsetB = mathfunction.vector2(0,0);
    
    self.UNIFORM_USE_BORDER = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_USE_BORDER");
    
    self.UNIFORM_SCALE_R = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_SCALE_R");
    self.UNIFORM_SCALE_G = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_SCALE_G");
    self.UNIFORM_SCALE_B = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_SCALE_B");

    self.UNIFORM_OFFSET_R = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_OFFSET_R");
    self.UNIFORM_OFFSET_G = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_OFFSET_G");
    self.UNIFORM_OFFSET_B = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_OFFSET_B");

    self.TEXTURE_SCREEN = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "TEXTURE_SCREEN");

    self.ATTRIBUTE_COORDNATE_R = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.INTERNAL,
        "ATTRIBUTE_COORDNATE_R");   
    self.ATTRIBUTE_COORDNATE_G = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.INTERNAL,
        "ATTRIBUTE_COORDNATE_G");  
    self.ATTRIBUTE_COORDNATE_B = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.INTERNAL,
        "ATTRIBUTE_COORDNATE_B");  

    local pathmaterial = venuscore.IFileSystem:PathAssembly("comm:/documents/material/rgbseperate.material");  
    self.material = host:CreateRenderObject(pathmaterial);   
   
    self:UpdateSize(size)

    return self.Queue;
end

function rgbseperate:SetScaleR(x,y)
    self.ScaleR:Set(x,y);
end

function rgbseperate:SetScaleG(x,y)
    self.ScaleG:Set(x,y);
end

function rgbseperate:SetScaleB(x,y)
    self.ScaleB:Set(x,y);
end

function rgbseperate:SetOffsetR(x,y)
    self.OffsetR:Set(x,y);
end

function rgbseperate:SetOffsetG(x,y)
    self.OffsetG:Set(x,y);
end

function rgbseperate:SetOffsetB(x,y)
    self.OffsetB:Set(x,y);
end

function rgbseperate:SetWrap(wraps,wrapt)
    self.WrapS = wraps;
    self.WrapT = wrapt;
    local tempx = 0;
    local tempy = 0;
    if self.WrapS == apolloengine.TextureEntity.TW_CLAMP_TO_BORDER then
        tempx = 1;
    end
    if self.WrapT == apolloengine.TextureEntity.TW_CLAMP_TO_BORDER then
        tempy = 1;
    end
    self.UseBorder:Set(tempx,tempy);
end

function rgbseperate:UpdateSize(size)  -- fortest
 end


function rgbseperate:Resizeview(size)
    self:UpdateSize(size)
end



function rgbseperate:Process(pipeline, Original, Scene, Output)
    Output:PushRenderTarget();
    Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);

    local texture =  Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 )
    local wrap = texture:GetWrap();
    texture:SetWrap(self.WrapS,self.WrapT);
    self.material:SetParameter(self.TEXTURE_SCREEN,
    texture);  

    self.material:SetParameter(self.UNIFORM_USE_BORDER,self.UseBorder );

    self.material:SetParameter(self.UNIFORM_SCALE_R,self.ScaleR );
    self.material:SetParameter(self.UNIFORM_SCALE_G,self.ScaleG );
    self.material:SetParameter(self.UNIFORM_SCALE_B,self.ScaleB );

    self.material:SetParameter(self.UNIFORM_OFFSET_R,self.OffsetR );
    self.material:SetParameter(self.UNIFORM_OFFSET_G,self.OffsetG );
    self.material:SetParameter(self.UNIFORM_OFFSET_B,self.OffsetB );

    self.material:Draw(pipeline);

    texture:SetWrap(wrap[1],wrap[2]);
end

return rgbseperate;

