local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local radialblur = {}
radialblur.Dn = 0;
radialblur.Queue = 100;

function radialblur:SetBlurCenter(center)
  self.Dn:SetParameter(self.BLUR_CENTER, mathfunction.vector2( center:x()/radialblur.size:x(), center:y()/radialblur.size:y() ) );
end

function radialblur:SetBlurScale(scale)
  self.Dn:SetParameter(self.BLUR_SCALE, mathfunction.vector1(scale:x() * 0.00018) );
end

function radialblur:Initialize(host, size)
  
  self.size = size;
  self.BlurCenter = mathfunction.vector2(size:x()/2, size:y()/2);
  self.BlurScale = mathfunction.vector1(0);
    --<!--  set the center parameters in fragment shader -->
  self.BLUR_CENTER = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_BLUR_CENTER");
    
  self.BLUR_SCALE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_BLUR_SCALE");

  self.Dn = host:CreateRenderObject("comm:documents/material/radialblur.material" );
  
  self:SetBlurCenter(self.BlurCenter);
  self:SetBlurScale(self.BlurScale );
  
  return self.Queue;
end

function radialblur:Resizeview(size)
  self.size = size;
  self.center = mathfunction.vector2(size:x()/2, size:y()/2);
  self:SetBlurCenter(self.center);
end

function radialblur:Process(pipeline, Original, Scene, Output)
  self:SetBlurCenter(self.BlurCenter);
  self:SetBlurScale(self.BlurScale );
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Dn:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Dn:Draw(pipeline);
end

return radialblur;