local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
require "utility"

local fastblur = {}
fastblur.RoGuassX = 0
fastblur.RoGuassY = 0
fastblur.Rt1 = 0;
fastblur.Rt2 = 0;

fastblur.Queue = 500;

--[[
  self.post = apollonode.PostEffect(); 
  if self.post:CreateResource("comm:script/apolloutility/posteffect/fastblur.lua") then
    self.maincamera:AttachPostEffect(self.post);
  end
  self.post:RegisterParameter("Blurriness");
  self.post:Blurriness(mathfunction.vector1(0.5));
  
  self.post:RegisterParameter("Horizontal");
  self.post:Horizontal(true);
  
  self.post:RegisterParameter("Vertical");
  self.post:Vertical(true);
  
  
  self.post:Blurriness(mathfunction.vector1(20*(math.cos(t * 0.5) * 0.5 + 0.5)));
]]--

function fastblur:Initialize(host, size)
  
  self.fbosize = mathfunction.vector2(size:x(), size:y());
  self.beginstep = 1;
  self.Blurriness = 1.0;
  self.Stepsize = mathfunction.vector2(1.0, 1.0);
  self.Horizontal = true;
  self.Vertical = true;
  
  self.GAUSSIAN_STEP = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "GAUSSIAN_STEP");
    
  self.GAUSSUAN_COORDNATE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.INTERNAL,
      "GAUSSUAN_COORDNATE");
  
  local GuassStep = self.Stepsize / size;
  
	self.RoGuassX = host:CreateRenderObject( "comm:documents/material/gaussianblur.material" );
	self.RoGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep:x(), 0 ) );
	
	self.RoGuassY = host:CreateRenderObject( "comm:documents/material/gaussianblur.material" );
	self.RoGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep:y() ) );
  
  self.Blit = host:CreateRenderObject( "comm:documents/material/imageblit.material" );
		
	self.Rt1 = host:CreateRenderTarget(
    apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      size,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      0));
  
  self.Rt2 = host:CreateRenderTarget(
    apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      size,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      0));
  
  return self.Queue;
end

function fastblur:Resizeview(size)
  self.fbosize = mathfunction.vector2(size:x(), size:y());
  local GuassStep = self.Stepsize / size;

	self.RoGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep:x(), 0 ) );
	self.RoGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep:y() ) );
end

function fastblur:_GetCount(newblurriness)
  local icount = math.ceil(newblurriness);
  icount = math.max(icount,1);
  return icount;
end

function fastblur:_UpdateStepsize(newblurriness, loop)
  local step = newblurriness - loop + 1;
  step = math.max(step, 0) * 2;
  if step ~= self.beginstep then
    --LOG("step "..step);
    self.beginstep = step;
    self.Stepsize:Set(step, step);
    local GuassStep = self.Stepsize / self.fbosize;
    self.RoGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep:x(), 0 ) );
    self.RoGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep:y() ) );
  end
end

function fastblur:_FullPass(newblurriness, pipeline, Original, Scene, Output)  
  local last = Scene;
  local icount = self:_GetCount(newblurriness);
  --LOG("count "..icount)
  for i = 1, icount do
    self:_UpdateStepsize(newblurriness, i);
    self.Rt1:PushRenderTarget();
    self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
    self.RoGuassX:SetParameter(
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
      last:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    self.RoGuassX:Draw(pipeline);	
    
    Output:PushRenderTarget();
    Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
    self.RoGuassY:SetParameter(
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
      self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    self.RoGuassY:Draw(pipeline);
    last = Output;
  end
  --LOG("----------------------------");
end

function fastblur:_HalfPass(newblurriness, ro, pipeline, Original, Scene, Output)
  local last = Scene;
  local icount = self:_GetCount(newblurriness);
  local rt = 1 == icount and Output or self.Rt1;
  for i = 1, icount do
    self:_UpdateStepsize(newblurriness, i);
    rt:PushRenderTarget();
    rt:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
    ro:SetParameter(
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
      last:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    ro:Draw(pipeline);	
    last = rt;
    rt = rt == self.Rt1 and self.Rt2 or self.Rt1;
    rt = i == icount - 1 and Output or rt;
  end  
end

function fastblur:_BlitPass(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Blit:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.Blit:Draw(pipeline);
end

local BLURRINESS_SCALER = 0.25;
function fastblur:Process(pipeline, Original, Scene, Output)
  local texture =  Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 )
  local wrap = texture:GetWrap();
  texture:SetWrap(apolloengine.TextureEntity.TW_MIRRORED_REPEAT,apolloengine.TextureEntity.TW_MIRRORED_REPEAT);
  
  local newblurriness;
  if type(self.Blurriness) == "number" then
    newblurriness = self.Blurriness * BLURRINESS_SCALER;
  else
    newblurriness = self.Blurriness:x() * BLURRINESS_SCALER;
  end  
  --LOG(newblurriness);
  if self.Horizontal and self.Vertical then
    self:_FullPass(newblurriness, pipeline, Original, Scene, Output);
  elseif self.Horizontal then
    self:_HalfPass(newblurriness, self.RoGuassX, pipeline, Original, Scene, Output);
  elseif self.Vertical then
    self:_HalfPass(newblurriness, self.RoGuassY, pipeline, Original, Scene, Output);
  else
    self:_BlitPass(pipeline, Original, Scene, Output);
    WARNING("Horizontal and Vertical both false");
  end
  texture:SetWrap(wrap[1],wrap[2]);
end

return fastblur;