local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local faceinfo = require "videodecet.faceinfo"
local facelift = require "apolloutility.posteffect.facelift.facelift"
local utility = require "apolloutility.nodeutility"

local pfacelifting = {}

pfacelifting.BigEye = 0;
pfacelifting.Queue = 200;

function pfacelifting:Initialize(host, size)
  
  self.WrapS = apolloengine.TextureEntity.TW_CLAMP_TO_EDGE;
  self.WrapT = apolloengine.TextureEntity.TW_CLAMP_TO_EDGE;
  
  self.UNIFORM_LEFT_EYE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                        "UNIFORM_LEFT_EYE");
  self.UNIFORM_RIGHT_EYE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                         "UNIFORM_RIGHT_EYE");
  self.UNIFORM_RADIUS = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                      "UNIFORM_RADIUS");
  self.UNIFORM_RATIOASPECT = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                           "UNIFORM_RATIOASPECT");
  self.UNIFORM_LEFT_PTS = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                        "UNIFORM_LEFT_PTS");
  self.UNIFORM_RIGHT_PTS = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                         "UNIFORM_RIGHT_PTS");
  self.UNIFORM_FACECOEF = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                        "UNIFORM_FACECOEF");
  self.UNIFORM_CHINCOEF = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                        "UNIFORM_CHINCOEF");                                                                    
  self.UNIFORM_NOSE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                    "UNIFORM_NOSE");
  self.UNIFORM_MOUSE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                     "UNIFORM_MOUSE");  
  self.UNIFORM_FACESNUM = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                        "UNIFORM_FACESNUM");
  self.UNIFORM_CHIN = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                    "UNIFORM_CHIN");                                                             
  self.UNIFORM_FACES_BOX = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                         "UNIFORM_FACES_BOX");
  self.UNIFORM_SCALERATIO = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                         "UNIFORM_SCALERATIO");
  -----3 lift face param
  self.FACEONEPARA = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                  "FACEONEPARA");
  self.FACETWOPARA = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                  "FACETWOPARA");
  self.MOUSEPARA = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                "MOUSEPARA");

  local vs, is = utility.Tesslate(128, 72, false, true);

  self.meta = apolloengine.RenderObjectMeshMetadate( 
        apolloengine.RenderObjectEntity.RM_TRIANGLES,
        apolloengine.ReferenceVertexMetadata(        
          apolloengine.VertexBufferEntity.MU_STATIC,--使用可以修改的显存区域
          vs),
        apolloengine.ReferenceIndicesMetadata(
          apolloengine.VertexBufferEntity.MU_STATIC,--使用不可修改的显存区域
          is));

  self.BigEye = host:CreateRenderObject(
    "comm:documents/material/biggereyes.material",
    self.meta);
  
  
  self.aspect_ratio = size:y()/size:x();
  self.BigEye:SetParameter(self.UNIFORM_RATIOASPECT, mathfunction.vector1(self.aspect_ratio));
  self.BigEye:SetParameter(self.UNIFORM_SCALERATIO, mathfunction.vector1(0.5));
  
  local lefteyes = mathfunction.vector2array();
  self.BigEye:SetParameter(self.UNIFORM_LEFT_EYE, lefteyes);
  local righteyes = mathfunction.vector2array();
  self.BigEye:SetParameter(self.UNIFORM_RIGHT_EYE, righteyes);
  local leftPointArray = mathfunction.vector2array();
  
  self.BigEye:SetParameter(self.UNIFORM_LEFT_PTS, leftPointArray);
  local rightPointArray = mathfunction.vector2array();
  self.BigEye:SetParameter(self.UNIFORM_RIGHT_PTS, rightPointArray);
  local nose = mathfunction.vector2array();
  
  self.BigEye:SetParameter(self.UNIFORM_NOSE, nose);
  local mouse = mathfunction.vector2array();
  self.BigEye:SetParameter(self.UNIFORM_MOUSE, mouse);
  local chin = mathfunction.vector2array();
  self.BigEye:SetParameter(self.UNIFORM_CHIN, chin);
  local radiuses = mathfunction.vector2array();
  self.BigEye:SetParameter(self.UNIFORM_RADIUS, radiuses);
  
  local faceonepara = mathfunction.vector2array();
  self.BigEye:SetParameter(self.FACEONEPARA, faceonepara);
  local facetwopara = mathfunction.vector2array();
  self.BigEye:SetParameter(self.FACETWOPARA, facetwopara);
  local mousepara = mathfunction.vector2array();
  self.BigEye:SetParameter(self.MOUSEPARA, mousepara);
  
  self.BigEye:SetParameter(self.UNIFORM_FACECOEF, mathfunction.vector1(0.0));
  self.BigEye:SetParameter(self.UNIFORM_CHINCOEF, mathfunction.vector1(0.0));
  self.BigEye:SetParameter(self.UNIFORM_FACESNUM, mathfunction.vector1(0.0));
  
  local facebox = mathfunction.vector4array();
  self.BigEye:SetParameter(self.UNIFORM_FACES_BOX, facebox);
  

  return self.Queue;
  
end

function pfacelifting:Resizeview(size)
  
  self.aspect_ratio = size:y()/size:x();
  self.BigEye:SetParameter(self.UNIFORM_RATIOASPECT, mathfunction.vector1(self.aspect_ratio));

end

function pfacelifting:Process(pipeline, Original, Scene, Output)
  
  local texture =  Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 )
  local wrap = texture:GetWrap();
  texture:SetWrap(self.WrapS,self.WrapT);
  
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.BigEye:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,texture);
  self.BigEye:Draw(pipeline);
  
  texture:SetWrap(wrap[1],wrap[2]);

end

return pfacelifting;