local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"
local facecute = require "facecute"
local faceinfo = require "videodecet.faceinfo";
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
require "utility"


local facelift  = {}

local faceonepara = {{0.3744,0.018},{0.3744,0.0216},{0.3744,0.0252},{0.3744,0.0216},{0.3744,0.0216},{0.3744,0.0216},{0.3744,0.0216},{0.3744,0.0216},{0.3744,0.0216}};
local facetwopara = {{0.3708,0.01854},{0.36,0.018},{0.342,0.0171},{0.36,0.0171},{0.3708,0.01836},{0.432,0.022248},{0.432,0.022248}};
local mousepara   = {{0.6,0.0114},{0.6,0.0252},{0.6,0.0252},{0.6,0.0252},{0.6,0.0114},{0.6,0.036},{0.6,0.0372},{0.6,0.0372},{0.6,0.0372},{0.6,0.036},{0.66,0.0228},{0.66,0.0228},{0.66,0.0228},{0.66,0.0228},{0.66,0.0228}};


function facelift:Initialize(camera)
  self.post = apollonode.PostEffect();
  self.post:CreateResource("comm:script/apolloutility/posteffect/facelift/pfacelifting.lua");
  
  self.resolution = apolloengine.Framework:GetResolution();
  self.aspect_ratio = self.resolution:y() / self.resolution:x();
  
  self.post:RegisterParameter("UNIFORM_FACESNUM", "comm:documents/material/biggereyes.material");
  self.post:RegisterParameter("UNIFORM_LEFT_EYE", "comm:documents/material/biggereyes.material");
  self.post:RegisterParameter("UNIFORM_RIGHT_EYE", "comm:documents/material/biggereyes.material");
  self.post:RegisterParameter("UNIFORM_RADIUS", "comm:documents/material/biggereyes.material");
  
  self.post:RegisterParameter("UNIFORM_FACECOEF", "comm:documents/material/biggereyes.material");
  self.post:RegisterParameter("UNIFORM_CHINCOEF", "comm:documents/material/biggereyes.material");
  self.post:RegisterParameter("UNIFORM_LEFT_PTS", "comm:documents/material/biggereyes.material");
  self.post:RegisterParameter("UNIFORM_RIGHT_PTS", "comm:documents/material/biggereyes.material");
  self.post:RegisterParameter("UNIFORM_NOSE", "comm:documents/material/biggereyes.material");
  self.post:RegisterParameter("UNIFORM_MOUSE", "comm:documents/material/biggereyes.material");
  self.post:RegisterParameter("UNIFORM_CHIN", "comm:documents/material/biggereyes.material");
  self.post:RegisterParameter("UNIFORM_SCALERATIO", "comm:documents/material/biggereyes.material");
  
  self.post:RegisterParameter("FACEONEPARA", "comm:documents/material/biggereyes.material");
  self.post:RegisterParameter("FACETWOPARA", "comm:documents/material/biggereyes.material");
  self.post:RegisterParameter("MOUSEPARA", "comm:documents/material/biggereyes.material");
  self.post:RegisterParameter("UNIFORM_RATIOASPECT", "comm:documents/material/biggereyes.material");


  self.post:RegisterParameter("UNIFORM_FACES_BOX", "comm:documents/material/biggereyes.material");

  local  facePara1 = mathfunction.vector2array();
  local  facePara2 = mathfunction.vector2array();
  local  mousePara0 = mathfunction.vector2array();
  
  for i = 1, 9, 1 do
     facePara1:PushBack(self:arrayToVec2(faceonepara[i]));
  end
  self.post:FACEONEPARA(facePara1);
    for i = 1, 7, 1 do
     facePara2:PushBack(self:arrayToVec2(facetwopara[i]));
  end
  self.post:FACETWOPARA(facePara2);
  for i = 1, 15, 1 do
    mousePara0:PushBack(self:arrayToVec2(mousepara[i]));
  end
  self.post:MOUSEPARA(mousePara0);
  -- different from aspect_ratio obtained in pfacelifting 
  self.post:UNIFORM_RATIOASPECT(mathfunction.vector1(self.aspect_ratio));

  --大眼参数
  self.eyecoef = 1.0;
  --瘦脸参数
  self.facecoef = 0.0;
  --瘦下巴参数
  self.chincoef = 0.0;
  self.rate = 1.0;
  
  self.t = 0;
  self.camera = camera
  camera:AttachPostEffect(self.post);

  
end

function facelift:Release()
  if self.camera ~= nil then
    self.camera:DetachPostEffect(self.post)
    self.post = nil
    self.camera = nil;
  end
end


function facelift:GetVector2dLength(vec)
  return math.sqrt(vec:x() * vec:x() + vec:y() * vec:y());
end


function facelift:GetDistance(src, dst)
  local dx = src[1] - dst[1];
  local dy = src[2] - dst[2];
  return math.sqrt(dx * dx + dy * dy);
end


function facelift:arrayToVec2(pt)
  return mathfunction.vector2(pt[1], pt[2]);
end


function facelift:GetBoundingBox(keypoints, paddingRatio)
  local min_x =  1;
  local max_x = -1;
  local min_y =  1;
  local max_y = -1;

  for id, pt in pairs(keypoints) do
    min_x = math.min(min_x, pt[1]);
    max_x = math.max(max_x, pt[1]);
    min_y = math.min(min_y, pt[2]);
    max_y = math.max(max_y, pt[2]);
  end

  width  = max_x - min_x;
  height = max_y - min_y;

  min_x = min_x - paddingRatio * width;
  max_x = max_x + paddingRatio * width;
  min_y = min_y - paddingRatio * height;
  max_y = max_y + paddingRatio * height;

  return mathfunction.vector4(min_x, max_x, min_y, max_y);
end

--脸周
function facelift:_UpdateFaceKeypoints(currentPoint, src, dst, radius, delta)
    local currentPointToUse = {currentPoint[1], currentPoint[2] * self.aspect_ratio};
    local srcToUse = {src[1], src[2] * self.aspect_ratio};  
    local r = self:GetDistance(currentPointToUse, srcToUse);
     
    local positionToUse = currentPoint;

    if r > radius then
       return currentPoint, 0;
    end
    local dir = mathfunction.vector2(src[1] - dst[1], src[2] - dst[2]);
    dir:NormalizeSelf();   
    local dist = radius * radius - r * r;
    local alpha = dist / (dist + (r-delta) * (r-delta));
    alpha = alpha * alpha;
    positionToUse[1] = positionToUse[1] - alpha * delta * dir:x();
    positionToUse[2] = positionToUse[2] - alpha * delta * dir:y();
    return positionToUse, 1;
  
end

--更新的算法
function facelift:_UpdateFaceKeypoints2(currentPoint, src, dst, radius, delta)

    local currentPointToUse = {currentPoint[1], currentPoint[2] * self.aspect_ratio};
    local srcToUse = {src[1], src[2] * self.aspect_ratio};  
    local r = self:GetDistance(currentPointToUse, srcToUse);
    local r2 = self:GetDistance(src,dst);
    local rmax = r2 * r2 * radius * radius ;
    local positionToUse = currentPoint;
    local dir = mathfunction.vector2(src[1] - dst[1], src[2] - dst[2]);
    dir:NormalizeSelf();

    if r*r > rmax then
      return currentPoint, 0;
    end

    local dist = rmax - r * r;
    local delta2 = delta * r2;
    local tmp = r - delta2
    local alpha = dist / (dist + tmp * tmp);
    alpha = alpha * alpha;
    positionToUse[1] = positionToUse[1] - alpha * delta2 * dir:x();
    positionToUse[2] = positionToUse[2] - alpha * delta2 * dir:y();
    return positionToUse, 1;  

end


--眼睛
function facelift:_UpdateEyesKeypoints(currentPoint, center, radius)
  
    local scaleRatio = 0.5; 
    
    local currentPositionToUse = {currentPoint[1], currentPoint[2] * self.aspect_ratio};
    local centerPostionToUse = {center[1], center[2] * self.aspect_ratio};
    local r = self:GetDistance(currentPositionToUse, centerPostionToUse);
    
    if r > radius then
      return currentPoint, 0;
    end
    
    local alpha = 1.0 + scaleRatio * (r / radius - 1.0) * (r / radius - 1.0);
    local positionToUse = currentPoint;
    positionToUse[1] = center[1] + alpha * (currentPoint[1] - center[1]);
    positionToUse[2] = center[2] + alpha * (currentPoint[2] - center[2]);
    return positionToUse, 1;
end


function facelift:NewframeCallback()
  if self.newframecallback ~= nil then
    return self.newframecallback
  end
  self.newframecallback = function()
    local lefteyes  = mathfunction.vector2array();
    local righteyes = mathfunction.vector2array();
    local leftPointArray  = mathfunction.vector2array();
    local rightPointArray = mathfunction.vector2array();
    local nose  = mathfunction.vector2array();
    local mouse = mathfunction.vector2array();
    local chin  = mathfunction.vector2array();
     
    local radiuses = mathfunction.vector2array();
    local facesBox = mathfunction.vector4array();

    local faces = videodecet:GetFaces();
    
    local maxFaceNum = 3;
    local faceNum = math.min(maxFaceNum, #faces);
    
    if (self.facecoef == 0 and self.eyecoef == 1) or next(faces) == nil then
      self.post:UNIFORM_FACESNUM(mathfunction.vector1(0));
    else
      self.post:UNIFORM_FACESNUM(mathfunction.vector1(faceNum));
    end
    
    if self.eyecoef == 1.0 then
       self.post:UNIFORM_SCALERATIO(mathfunction.vector1(0.0));
    else
       self.post:UNIFORM_SCALERATIO(mathfunction.vector1(0.5));
    end
     
     
    for k=1, faceNum, 1 do
      local faceinfo = faces[k];
      self.keypoints = faceinfo:GetKeypointArray();
      --商汤从0开始，Lua从1开始，index需+1
      --keypointNum = #keypoints;
      --修正侧脸问题
      self.rotate = faceinfo:GetRotation();
      self.rate = (1.0 - math.abs(self.rotate[3]/40));
      if(self.rate < 0) then
        self.rate = 0.0;
      end
      --左眼
      local c1 = self:arrayToVec2(self.keypoints[75]);
      local pt2 = self:arrayToVec2(self.keypoints[55]);
      self.r1 = self:GetVector2dLength(pt2 - c1) ;
      lefteyes:PushBack(c1);
      
      --右眼 
      local c2 = self:arrayToVec2(self.keypoints[78]);
      pt2 = self:arrayToVec2(self.keypoints[60]);
      self.r2 = self:GetVector2dLength(pt2 - c2);
      righteyes:PushBack(c2);
            
      --大眼系数
      radiuses:PushBack(mathfunction.vector2(self.r1 * self.eyecoef * 0.72, self.r2 * self.eyecoef * 0.72));

      --左脸     
      for i = 1,16,1 do
        leftPointArray:PushBack(self:arrayToVec2(self.keypoints[i]));
      end

      --右脸
      for i = 33,18,-1 do
        rightPointArray:PushBack(self:arrayToVec2(self.keypoints[i]));
      end

      --鼻子
      self.ns = self.keypoints[44];      
      nose:PushBack(self:arrayToVec2(self.keypoints[46]));
      for i = 81,84,1 do
        nose:PushBack(self:arrayToVec2(self.keypoints[i]));
      end 
      nose:PushBack(self:arrayToVec2(self.keypoints[50]));
      nose:PushBack(self:arrayToVec2(self.keypoints[44]));

      --嘴
      mouse:PushBack(self:arrayToVec2(self.keypoints[85]));
      mouse:PushBack(self:arrayToVec2(self.keypoints[91]));--it changes the mouse point order 
      for i = 86,101,1 do
        if i ~= 91 then
          mouse:PushBack(self:arrayToVec2(self.keypoints[i]));
        end
      end

      --下巴
      chin:PushBack(self:arrayToVec2(self.keypoints[17]));
      
      --脸部包围盒
      local box = self:GetBoundingBox(self.keypoints, 0.25);
      facesBox:PushBack(box);
      
      self.flag = 0;
      self:_getWarpedKeyPoints();
      faceinfo:UpdateKeypoints(self.keypoints);  
      videodecet:PushNewFaceLandMark();
      
    end
    if faceNum > 0 then
        self.post:UNIFORM_LEFT_EYE(lefteyes);
        self.post:UNIFORM_RIGHT_EYE(righteyes);
        self.post:UNIFORM_RADIUS(radiuses);
        self.post:UNIFORM_FACECOEF(mathfunction.vector1(self.facecoef*self.rate));
        self.post:UNIFORM_CHINCOEF(mathfunction.vector1(self.chincoef*self.rate));
        self.post:UNIFORM_LEFT_PTS(leftPointArray);
        self.post:UNIFORM_RIGHT_PTS(rightPointArray);
        self.post:UNIFORM_NOSE(nose);
        self.post:UNIFORM_MOUSE(mouse);
        self.post:UNIFORM_CHIN(chin);
        self.post:UNIFORM_FACES_BOX(facesBox);
    end
  end
  
  return self.newframecallback;
end

function facelift:GetNewframeCallback()
    return self.newframecallback
end

function facelift:_getWarpedKeyPoints()

  --更新眼周关键点位置
  --眼眶中心可不更新
  --faceinfo:UpdateKeypoints(self.keypoints);
  local j = 1;
  for i=53,77,1 do
    if i ~= 75 and (i <= 64 or i >= 73) then
      local pt = self.keypoints[i];
      pt,self.flag = self:_UpdateEyesKeypoints(pt, self.keypoints[75], self.r1 * self.eyecoef * 0.72);         
      pt,self.flag = self:_UpdateEyesKeypoints(pt, self.keypoints[78], self.r2 * self.eyecoef * 0.72);
      self.keypoints[i] = pt;
    end
  end
        
  --更新脸周位置 
  --左脸
  self.ns = self.keypoints[44];
  for i = 1,9,1 do
    local pt = self.keypoints[i];        
    pt,self.flag = self:_UpdateFaceKeypoints(pt, self.keypoints[i], self.ns, faceonepara[i][1], faceonepara[i][2]*self.facecoef*1.2);  
    self.keypoints[i] = pt;
  end
  
  j = 1;
  --右脸
  for i = 33,25,-1 do
    local pt = self.keypoints[i];      
    pt,self.flag = self:_UpdateFaceKeypoints(pt, self.keypoints[i], self.ns, faceonepara[j][1], faceonepara[j][2]*self.facecoef*1.2);  
    j = j + 1;
    self.keypoints[i] = pt;
  end
  
  j = 1;
  --左下巴
  for i = 10,16,1 do
    local pt = self.keypoints[i];      
    local faceindex = 30;  
    --pt,self.flag = self:_UpdateFaceKeypoints(pt, self.keypoints[i], self.ns, facetwopara[j][1], facetwopara[j][2]*self.chincoef);  
    pt,self.flag = self:_UpdateFaceKeypoints(pt, self.keypoints[i], self.keypoints[faceindex], facetwopara[j][1], facetwopara[j][2]*self.chincoef*2.3);
    faceindex = faceindex - 1;  
    j = j + 1;
    self.keypoints[i] = pt;
  end
  
  j = 1;
  --右下巴
  for i = 24,18,-1 do
    local pt = self.keypoints[i]; 
    local faceindex = 4;  
   -- pt,self.flag = self:_UpdateFaceKeypoints(pt, self.keypoints[i], self.ns, facetwopara[j][1], facetwopara[j][2]*self.chincoef);  
    pt,self.flag = self:_UpdateFaceKeypoints(pt, self.keypoints[i], self.keypoints[faceindex], facetwopara[j][1], facetwopara[j][2]*self.chincoef*2.3);
    faceindex = faceindex + 1;  
    j = j + 1;
    self.keypoints[i] = pt;
  end
  
  --下巴尖
  local pt = self.keypoints[17];       
  pt,self.flag = self:_UpdateFaceKeypoints(pt, self.keypoints[17], self.ns, 0.396, 0.0198*self.chincoef*1.2);  
  --pt,self.flag = self:_UpdateFaceKeypoints(pt, self.keypoints[17], self.ns, 0.396, 0.0198*self.chincoef); 
  self.keypoints[17] = pt;
  --嘴巴
  --self.keypoints[85],self.flag = self:_UpdateFaceKeypoints2(self.keypoints[85], self.keypoints[85], self.keypoints[78], 0.165, 0.0228*self.facecoef*1.1);
  --self.keypoints[91],self.flag = self:_UpdateFaceKeypoints2(self.keypoints[91], self.keypoints[91], self.keypoints[75], 0.165, 0.0228*self.facecoef*1.1);
  --self.ns3 = self.keypoints[46];
  --for i = 86,90,1 do
      --self.keypoints[i],self.flag = self:_UpdateFaceKeypoints2(self.keypoints[i], self.keypoints[i], self.ns3, mousepara[i-85][1], mousepara[i-85][2]*self.facecoef*1.1); 
  --end
  --for i = 92,101,1 do
      --self.keypoints[i],self.flag = self:_UpdateFaceKeypoints2(self.keypoints[i], self.keypoints[i], self.ns3, mousepara[i-86][1], mousepara[i-86][2]*self.facecoef*1.1);
  --end
   

  --鼻子
  self.ns2 = {self.keypoints[44][1],self.keypoints[44][2]*1.05};
  local d3 = self:GetDistance(self.keypoints[83],self.keypoints[84]);
  --self.keypoints[46],self.flag = self:_UpdateFaceKeypoints(self.keypoints[46], self.keypoints[46], self.ns2, 0.72*d3, 0.036*d3*self.facecoef);
  self.keypoints[81],self.flag = self:_UpdateFaceKeypoints(self.keypoints[81], self.keypoints[81], self.keypoints[82], 0.72*d3, 0.054*d3*self.facecoef*1.1);
  self.keypoints[82],self.flag = self:_UpdateFaceKeypoints(self.keypoints[82], self.keypoints[82], self.keypoints[81], 0.72*d3, 0.054*d3*self.facecoef*1.1);
  self.keypoints[83],self.flag = self:_UpdateFaceKeypoints(self.keypoints[83], self.keypoints[83], self.keypoints[84], 0.72*d3, 0.054*d3*self.facecoef*1.1);
  self.keypoints[84],self.flag = self:_UpdateFaceKeypoints(self.keypoints[84], self.keypoints[84], self.keypoints[83], 0.72*d3, 0.054*d3*self.facecoef*1.1);
  --self.keypoints[50],self.flag = self:_UpdateFaceKeypoints(self.keypoints[50], self.keypoints[50], self.ns2, 0.72*d3, 0.018*d3*self.facecoef*1.1);


end


function facelift:setWarpLevel(coefeye,coefface,coefchin)
  
  self.eyecoef = 1.0 + coefeye * 0.05 * 0.22;
  self.facecoef = math.sqrt(coefface * 0.05 * 0.2) * 0.48;
  self.chincoef = math.sqrt(coefchin * 0.05 * 0.2) * 0.48;
  
  --[[local yingshe  = {};
  yingshe[0] = 0.0;
  yingshe[4] = 0.096;
  yingshe[6] = 0.192;
  yingshe[7] = 0.288;
  yingshe[8] = 0.384;
  yingshe[10] = 0.48;
  
  self.facecoef = yingshe[math.floor(coefface*10)];
  self.chincoef = yingshe[math.floor(coefface*10)];
  --self.facecoef1 = 0;
  --self.chincoef1 = 0;]]--
end

function facelift:setEyeParam(coefeye)
  self.eyecoef = 1.0 + coefeye * 0.05 * 0.22;
end

function facelift:setFaceParam(coefface)
  self.facecoef = math.sqrt(coefface * 0.05 * 0.2) * 0.48;
end

function facelift:setChinParam(coefchin)
  self.chincoef = math.sqrt(coefchin * 0.05 * 0.2) * 0.48;
end


function facelift:Disable()
  self.post:Disable();
 end
 
 function facelift:Enable()
  self.post:Enable();
 end
return facelift;
