local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local bloom = {}
bloom.RoLumi = 0
bloom.RoGuassX = 0
bloom.RoGuassY = 0
bloom.RoCombine = 0
bloom.Rt1 = 0;
bloom.Rt2 = 0;

bloom.Queue = 500;

function bloom:Initialize(host, size)
  
  self.COMBINE_WEIRHT = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "COMBINE_WEIRHT");
    
  self.GAUSSIAN_STEP = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "GAUSSIAN_STEP");
    
  self.LUMINACE_THRESHOLD = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "LUMINACE_THRESHOLD");
    
  self.GAUSSUAN_COORDNATE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.INTERNAL,
      "GAUSSUAN_COORDNATE");      
  
  
	local targetsize = size / 4;
	local GuassStep = mathfunction.vector2( 2.0, 2.0 ) / targetsize;
  
	self.RoLumi = host:CreateRenderObject( "comm:documents/material/luminance.material" );
	self.RoLumi:SetParameter(self.LUMINACE_THRESHOLD, mathfunction.vector1( 1.0 ) );
	
	self.RoGuassX = host:CreateRenderObject( "comm:documents/material/gaussianblur.material" );
	self.RoGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep:x(), 0 ) );
	
	self.RoGuassY = host:CreateRenderObject( "comm:documents/material/gaussianblur.material" );
	self.RoGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep:y() ) );
	
	self.RoCombine = host:CreateRenderObject( "comm:documents/material/combine.material" );
	self.RoCombine:SetParameter( self.COMBINE_WEIRHT, mathfunction.vector2( 1, 2 ) );
	
	self.Rt1 = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_A, targetsize );
	self.Rt2 = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_B, targetsize );
  
  return self.Queue;
end

function bloom:Resizeview(size)
	local targetsize = size / 4;
	local GuassStep = mathfunction.vector2( 2.0, 2.0 ) / targetsize;

	self.RoGuassX:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep:x(), 0 ) );
	self.RoGuassY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( 0, GuassStep:y() ) );
end


function bloom:Process(pipeline, Original, Scene, Output)
	
	self.Rt1:PushRenderTarget();
	self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	self.RoLumi:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.RoLumi:Draw(pipeline);
		
	self.Rt2:PushRenderTarget();
	self.Rt2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	self.RoGuassX:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.RoGuassX:Draw(pipeline);
		
	self.Rt1:PushRenderTarget();
	self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	self.RoGuassY:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.RoGuassY:Draw(pipeline);
	
	self.Rt2:PushRenderTarget();
	self.Rt2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	self.RoGuassX:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.RoGuassX:Draw(pipeline);
	
	self.Rt1:PushRenderTarget();
	self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	self.RoGuassX:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.RoGuassX:Draw(pipeline);	
		
	Output:PushRenderTarget();
	Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	self.RoCombine:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.RoCombine:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_GLOSSINESS,
		self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.RoCombine:Draw(pipeline);
end

return bloom;