--@author      : Chen Wei
--@date        : 2019-06-26
--@description : lua script for line strip render
--@version     : 1.0

local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore    = require "venuscore"
local Object       = require "classic"

local LineStripRender = Object:extend();

function LineStripRender:new(line_num, vertex_num_per_line, color)
    self.line_num            = line_num;
    self.vertex_num_per_line = vertex_num_per_line;
    self.vertex_count        = line_num * vertex_num_per_line;
    
    apolloengine.ShaderEntity.POINT_COLOR = 
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "POINT_COLOR");
    --[[
    apolloengine.ShaderEntity.ATTRIBUTE_POSTION_2DIM = 
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.ATTRIBUTE,
      "ATTRIBUTE_POSITION2D");
      --]]

    self.node   = apolloengine.Node();               --创建基础节点
    self.render = apolloengine.RenderComponent();    --创建基础渲染组建
    self.node:AttachComponent(self.render);          --将渲染组建挂在在节点之上

    --创建顶点流
    self.vertexstream = apolloengine.VertexStream();
    self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
      apolloengine.VertexBufferEntity.DT_FLOAT,
      apolloengine.VertexBufferEntity.DT_FLOAT,2);
    self.vertexstream:ReserveBuffer(self.vertex_count);
    
    --索引流
    self.indexstream = apolloengine.IndicesStream();
    self.indexstream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT32);
    self.indexstream:ReserveBuffer((vertex_num_per_line * 2 - 2) * line_num);

    --初始化顶点
    for i=1, self.vertex_count do
      self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(0,0));
    end 
    --初始化索引
    for i = 1, line_num do
      for j = 1, vertex_num_per_line -1 do
        self.indexstream:PushIndicesData((i - 1) * vertex_num_per_line + (j - 1));  --0
        self.indexstream:PushIndicesData((i - 1) * vertex_num_per_line + j); --1
      end
    end
    
 

    self.render:PushMetadata(apolloengine.RenderObjectMaterialMetadata(apolloengine.PathMetadata("comm:documents/material/pointrender_1.material")));
    
    --创建可以渲染的顶点流
    self.render:PushMetadata(apolloengine.RenderObjectMeshMetadate(
        apolloengine.RenderObjectEntity.RM_LINES,apolloengine.ReferenceVertexMetadata(
          apolloengine.VertexBufferEntity.MU_DYNAMIC,self.vertexstream), --顶点数据需要修改
      apolloengine.ReferenceIndicesMetadata(
        apolloengine.VertexBufferEntity.MU_STATIC,--索引不需要修改
        self.indexstream)));

    self.render:CreateResource();
    
    self.render:SetParameter(apolloengine.ShaderEntity.POINT_COLOR, color);
end
  
function LineStripRender:SetShow(is_show)
    if is_show then
        self.render:SetRenderProperty(apolloengine.RenderObjectEntity.RP_SHOW);
    else
        self.render:EraseRenderProperty(apolloengine.RenderObjectEntity.RP_SHOW);
    end  
end

function LineStripRender:Update(vertex_stream)
    self.render:ChangeVertexBuffer(vertex_stream);
end
  
return LineStripRender;