local apolloengine = require "apolloengine"
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local defined = require "apolloutility.defiend"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"
require "utility"
local filterqueue = {}

function filterqueue:_CreateCamera(near,far,pos,lookat,up,color,sequence,resolution)
  local camera = apollonode.CameraNode(resolution);--新建摄像机
  camera:Deactivate();
  camera:CreateRealCameraProjection(near, far);--设置摄像机
  camera:LookAt(pos, lookat, up);
  camera:SetSequence(sequence);
  
  local rt = apolloengine.RenderTargetEntity();--创建一个FBO
  --[[
  rt:PushMetadata(--设置FBO格式
      apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        color,--清屏颜色
        apolloengine.Framework:GetViewport(),
        apolloengine.Framework:GetResolution()));--分辨率
  local tex = rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);--增加color0纹理
  tex:PushMetadata(--创建纹理
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
         apolloengine.Framework:GetResolution()));
  --]]
  
  local viewport = mathfunction.vector4(0.0,0.0,resolution:x(),resolution:y())
  rt:PushMetadata(--设置FBO格式
      apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        color,--清屏颜色
        viewport,
        resolution));--分辨率
  
  local tex = rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);--增加color0纹理
  tex:PushMetadata(--创建纹理
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        resolution));
  rt:CreateResource();
  
  camera:AttachRenderTarget(rt);
  
  return camera, rt, tex;
end

--NOTE:分辨率变化了要重新创建filter相机和target,也要重新调用CeateFilter
function filterqueue:ResetCustomFilter(resolution)
  
  --Deactive 所有后处理，否则后面挂不上去
  for i = 1, #self.filters do
    local filterArray = self.filters[i];
    for j = 1, #filterArray do 
      self.cameras[i]:DetachPostEffect(filterArray[j]);
    end
  end
  
  self.cameras = {};
  self.rendertargets = {};
  self.filters = {};
  self.textures = {};
  self.sequences = {};
  self.quadnodes = {};
  self.cameraIndex = 1;
  self.tex = nil;
  self.resolution = resolution;
  collectgarbage();
   
  local near = self.maincamera:GetNear();
  local far = self.maincamera:GetFar(); 
  local pos = self.maincamera:GetWorldPosition();
  local lookat = pos + self.maincamera:GetForward();
  local up = self.maincamera:GetUp();
  local color = mathfunction.vector4(1.0,1.0,1.0,1.0); --清屏颜色
  
  for i=1, self.rectnum, 1 do
    local camera, rt, tex = self:_CreateCamera(near,far,pos,lookat,up,color,defined.biugo_camera_min_sequence+i,resolution);
    table.insert(self.textures, tex);
    table.insert(self.cameras, camera);
    table.insert(self.rendertargets, rt);
    table.insert(self.sequences, camera:GetSequence());
  end
end

--这里只管主相机
function filterqueue:Initialize(maincamera,num,resolution)
  self.maincamera = maincamera;
  self.mainposteffect = {};
  self.rectnum = num;
  self.filters = {};
  self:ResetCustomFilter(resolution);
end

function filterqueue:Clear()
  self.maincamera = nil;
  self.cameras = {};
  self.rendertargets = {};
  self.filters = {};
  self.textures = {};
  self.sequences = {};
  self.quadnodes = {};
  self.rectnum = 0;
  self.cameraIndex = 1; 
  self:ClearMaincameraAttach();
end


function filterqueue:Createfilter(rectfilter)
  if self.cameraIndex > self.rectnum then
    ERROR("there are no spare cameras ");
    return;
  end
  
  local quadnode = apollonode.QuadNode();
  quadnode:SetShow(true);
  quadnode:CreateResource(defined.blit_material_path, true);
  quadnode:SetSequence(self.sequences[self.cameraIndex]);
  quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,self.tex);
  table.insert(self.quadnodes, quadnode);
  
  local posteffectnum = #rectfilter;
  local filterArray = {};
  for i=1, posteffectnum, 1 do
     rectfilter[i]:SetQueue(i);
     self.cameras[self.cameraIndex]:AttachPostEffect(rectfilter[i]);
     --需要把filter保存下来
     table.insert(filterArray,rectfilter[i]);
  end
  table.insert(self.filters,filterArray);
  self.cameras[self.cameraIndex]:Activate();
  self.cameraIndex  = self.cameraIndex + 1;
  local r = self.textures[self.cameraIndex-1];
  return r;
end


function filterqueue:SetCustomTexture(customtex)
  self.tex = customtex;
  for i = 1, #self.quadnodes do
    self.quadnodes[i]:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,self.tex);
  end
end

function filterqueue:AttachMaincamera(rectfilter)
  if self.maincamera == nil then
    ERROR("can't get maincamera");
    return;
  end
  local posteffectnum = #rectfilter;
  for i=1, posteffectnum, 1 do
    rectfilter[i]:SetQueue(i);
    self.maincamera:AttachPostEffect(rectfilter[i]);
    table.insert(self.mainposteffect,rectfilter[i]);
  end
end

function filterqueue:ClearMaincameraAttach()
  if self.mainposteffect ~= nil then 
    for key, value in pairs(self.mainposteffect) do
      value:Disable();
      value = nil;
    end 
    self.mainposteffect = {};
    collectgarbage();
  end
end


return filterqueue;
