local apolloengine = require "apolloengine"
local b3 = require 'behavior3.b3';
require 'behavior3.core.Action'

local modelupdate = b3.Class("ModelUpdate", b3.Action)

function modelupdate:ctor()
	b3.Action.ctor(self)	
	self.name = "ModelUpdate"
end


local AS_ERROR = apolloengine.SkeletonComponent.AS_ERROR;
local AS_PLAYING = apolloengine.SkeletonComponent.AS_PLAYING;
local AS_DONE = apolloengine.SkeletonComponent.AS_DONE;
local AS_STOP = apolloengine.SkeletonComponent.AS_STOP;
function modelupdate:tick(tick)
  local model = tick.blackboard:get("modelscope");
  local timespan = tick.blackboard:get("timespan");
  local res = model:UpdateAnimation(timespan);
  if AS_PLAYING == res then
    return b3.RUNNING;
  elseif AS_DONE == res then
    return b3.SUCCESS
  end
  return b3.FAILURE;
end

return modelupdate;