require "utility"
local apolloengine = require "apolloengine"
local apollonode = require "apolloutility.apollonode"
local mathfunction = require "mathfunction"
local defined = require "apolloutility.defiend"
local haircolordefined = require "facecute.haircolor.haircolordefined"
local renderqueue = require "apolloutility.renderqueue"
local Object = require "classic"

local HistoricalFrameBase = Object:extend();

function HistoricalFrameBase:new(maincamera,framenum,sequence,material,size)
  self.historicalqueue = framenum; --需要历史帧长度，（现在取的就是上一帧纹理)
  self.count = 0;
  self.updated = false; 
  self.isGetEnoughFrame = false;
  self.isShow = false;
  self.rtqueue = {};
  self.texqueue = {};
  
  local near = maincamera:GetNear();
  local far = maincamera:GetFar();
  local pos = maincamera:GetWorldPosition();
  local lookat = pos + maincamera:GetForward();
  local up = maincamera:GetUp();
  local color = mathfunction.vector4(0.0,0.0,0.0,0.0); --清屏颜色
  
  if size == nil then
    self.historical_camera = apollonode.CameraNode();
  else
    self.historical_camera = apollonode.CameraNode(size);
  end
  
  self.historical_camera:Deactivate();
  self.historical_camera:CreateRealCameraProjection(near, far);
  self.historical_camera:LookAt(pos, lookat, up);
  self.historical_camera:SetSequence(sequence - 1);
  
  
  for i=1, self.historicalqueue, 1 do
    local rt, tex = self:_CreateRendertarget(color);
    table.insert(self.rtqueue,rt);
    table.insert(self.texqueue,tex);
  end
  
  self.quadnode = apollonode.QuadNode();
  self.quadnode:SetShow(false);
  self.quadnode:CreateResource(material, true);
  self.quadnode:SetSequence(sequence - 1);
    
end

function HistoricalFrameBase:_CreateRendertarget(color)
  local resolution = self.historical_camera:GetCameraResolution();
  local rt = apolloengine.RenderTargetEntity();
  rt:PushMetadata(--设置FBO格式
    apolloengine.RenderTargetMetadata(
      apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      color,--清屏颜色
      mathfunction.vector4(0,0,resolution:x(),resolution:y()),
      resolution));--分辨率
  local tex = rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
  tex:PushMetadata(--创建纹理
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      resolution));
  rt:CreateResource();
  return rt, tex;
end

function HistoricalFrameBase:Update()
  if self.quadnode == nil then
    return;
  end
  --self.updated = true;
  if self.vediotex ~= nil then
    self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, self.vediotex);
  else
    self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, renderqueue:GetTexture(renderqueue:GetLink(renderqueue.CAMERA_LAYER_ZERO)));
  end

  if self.isShow == true then
    local temprt = self.rtqueue[self.historicalqueue];
    local temptex = self.texqueue[self.historicalqueue];
    for i=self.historicalqueue,2,-1 do
      self.rtqueue[i] = self.rtqueue[i-1];
      self.texqueue[i] = self.texqueue[i-1];
    end
    self.rtqueue[1] = temprt;
    self.texqueue[1] = temptex;
    self.count = self.count + 1;
    self.historical_camera:AttachRenderTarget(self.rtqueue[1]);
  end
  if self.count == self.historicalqueue then
    self.count = self.count - 1;
    self.isGetEnoughFrame = true;
  end
end

function HistoricalFrameBase:SetShow(isShow)
  --if self.updated then
    if self.isShow ~= isShow then
      self.isShow = isShow
      self.quadnode:SetShow(isShow);
      self.historical_camera:Activate();
    end
  --end  
end

function HistoricalFrameBase:SetVideoTexture(vedieotex)
  self.vediotex = vedieotex;
end

function HistoricalFrameBase:GetFrame()
  return self.texqueue;
end

function HistoricalFrameBase:IsGetEnoughFrame()
  return self.isGetEnoughFrame;
end

function HistoricalFrameBase:Clear()
  self.historical_camera:Deactivate();
  self.historical_camera = nil;
  if self.quadnode ~= nil then
    self.quadnode:SetShow(false);
    self.quadnode = nil;
  end
  self.count = 0;
  self.isShow = false;
  self.updated = false; 
  self.rtqueue = {};
  self.texqueue = {};
end

return HistoricalFrameBase;
