local textureloader = require "apolloutility.asynctexture.textureloader"
local defiend = require "apolloutility.defiend"
local mathfunction = require "mathfunction"
local object = require "classic"
local ae = require "apolloengine"
local vc = require "venuscore"
require "utility"
require "math"



local AsyncTexture = object:extend();

local MAX_FPS = 30;
local RGB_INDEX = 1;
local ALPHA_INDEX = 2;

function AsyncTexture.SetMaxfps(fps)
  MAX_FPS = fps;
end

function AsyncTexture.Wait()
  return textureloader:Wait();
end

function AsyncTexture.Clear()
  return textureloader:Clear();
end

function AsyncTexture:new()
  self:_Reset();
  self.textureinsert = function (picoder, channelindex, tex)
    local imagetable = self.textures[picoder] or {}
    self.textures[picoder] = imagetable;
    imagetable[channelindex] = tex;    
    if self.loadcount == #imagetable then
      self.isLoading = false;
      for index, value in pairs(self.textures) do
        if not self.keeptexture
          and index ~= self.lastOrder
          and index ~= self.currentOrder
          and index ~= self.nextOrder then
            if self.textures[index] then
              local t = self.textures[index];
              if t[RGB_INDEX] then
                t[RGB_INDEX]:Discard();
              end              
              if t[ALPHA_INDEX] then
                t[ALPHA_INDEX]:Discard();
              end
            end            
            self.textures[index] = nil
        end        
      end    
    end  
  end  
  self.agent, self.callbackindex = g_callbackhandle:RegisterCallback(self.textureinsert);
  self.loopCount = 0;
  self.curLoopCount = 0;
end

function AsyncTexture:ReStart()

  self.accTime = 0;
  self.curLoopCount = 0;
  self:Preloading();

end

function AsyncTexture:SetAccTime(time)
  self.accTime = time;
end

function AsyncTexture:GetTotalTime()
  return self.totalTime;
end



function AsyncTexture:_Reset()
  self.accTime = 0;
  self.fixedtimespan = 0;
  self.autoskip = false;
  self.currentOrder = -1;
  self.nextOrder = -1;
  self.lastOrder = -1;
  self.isLoop = false;
  self.premul = false;
  self.keepsource = false;
  self.textures = {};
  self.totalTime = 0;
  self.texCnt  = 0;
  self.keeptexture = false;
  self.isLoading = false;
  self.isPlaying = false;
end

function AsyncTexture:AutoSkip()
  self.autoskip = true;
end

function AsyncTexture:SetKeepSource(keep)
  self.keepsource = keep;
end

function AsyncTexture:TryKeepTexture()
  if 0 == self.texCnt then
    error("call this function after loaded!");
  elseif self.texCnt > defiend.sequence_animation_keep_max_count then
    WARNING(string.format("path %s have to many texture to keep", self.rootPath));
  else
    self.keeptexture = true;
  end  
end

function AsyncTexture:UsingPremultiplyAlphaMode()
  self.premul = true;
end

--顺序读取一个序列帧纹理集
function AsyncTexture:SequentialLoad(fps, loop, beginid, path, alpha_path, loopCount)
  fps = fps > MAX_FPS and MAX_FPS or fps;
  self.loadcount = 1;
  self.isLoop = loop;
  self.fps = fps;
  self.fixedtimespan = 1.0 / fps;
  self.beginid = beginid;  
  if alpha_path then
    self.alpha = true;
    self.loadcount = 2;
    local index = string.find(alpha_path, "/[^/]*$");
    self.alphaRootPath= string.sub(alpha_path, 0, index);
    self.alphaPathFormat= string.sub(alpha_path, index + 1, #alpha_path);
  end  
  local index = string.find(path, "/[^/]*$");
  self.rootPath = string.sub(path, 0, index);
  self.pathFormat = string.sub(path, index + 1, #path);
  local b,e = string.find(self.pathFormat,"%%%d+d");
  local digCnt = tonumber(string.sub(self.pathFormat,b + 2,e - 1));
  
  
  local strBeg = string.sub(self.pathFormat,1,b - 1);
  local strEnd = string.sub(self.pathFormat,e + 1,string.len(self.pathFormat));
  
  for i = 1,digCnt,1 do
    strBeg = strBeg .. "?";
  end
  self.wildcard = strBeg .. strEnd;  
  self.texCnt = vc.IFileSystem:CountingFile(self.rootPath, self.wildcard);
  if self.texCnt == 0 then
    ERROR("no texture in folder: "..self.rootPath);
  else
    self.isPlaying = true;
  end
  self.totalTime = self.texCnt / fps;
  self.loopCount = loopCount;
  self.curLoopCount = 0;
  return self.texCnt ~= 0;
end

function AsyncTexture:Preloading()
  self:Update(0);
end

function AsyncTexture:isPlaying()
  return self.isPlaying;
end

function AsyncTexture:_GetNextIndex(picOrder)
  if picOrder + 1 >= self.texCnt then
    return self.beginid;
  end
  return picOrder + 1;
end


function AsyncTexture:_GetFileName(picOrder)
  local picName = string.format(self.pathFormat,picOrder);
  local alphapath;
  if self.alpha then
    alphapath = string.format(self.alphaPathFormat, picOrder);
    alphapath = self.alphaRootPath.."/"..alphapath;
  end  
  return self.rootPath .. "/" .. picName, alphapath, alphapath;
end
function AsyncTexture:ResetLoopCount()
   self.curLoopCount = 0;
end

function AsyncTexture:GetLoopCount()
   return self.curLoopCount;
end

function AsyncTexture:IsNewStart()
  if(self.accTime==0)
  then
    return true;
  else
    return false;
  end
end

--同步的读取一张临时资源，获取尺寸，只能在初始化的时候使用
function AsyncTexture:GetSize()
  local rgbpath = self:_GetFileName(self.currentOrder);
  local tex = ae.TextureEntity();
  tex:PushMetadata(ae.TextureFileMetadata(
    ae.TextureEntity.TU_STATIC,
    ae.TextureEntity.PF_AUTO,
    1, false,
    ae.TextureEntity.TW_CLAMP_TO_BORDER,
    ae.TextureEntity.TW_CLAMP_TO_BORDER,
    ae.TextureEntity.TF_LINEAR,
    ae.TextureEntity.TF_LINEAR,
    rgbpath));
  local size;
  if tex:CreateResource() then
    size = tex:GetSize();
  else
    size = mathfunction.vector2(128,128);
  end  
  return size;
end
function AsyncTexture:GetNextLoopCount(deltaT)
  
 local accTime = (self.autoskip or deltaT < self.fixedtimespan)
    and self.accTime + deltaT
    or self.accTime + self.fixedtimespan;
  if accTime>= self.totalTime 
  then
    return  self.curLoopCount+1;
  else
    return  self.curLoopCount;
  end
  
end

  

--更新并且返回当前纹理与当前帧
function AsyncTexture:Update(deltaT)
  self.accTime = (self.autoskip or deltaT < self.fixedtimespan)
    and self.accTime + deltaT
    or self.accTime + self.fixedtimespan;
  if self.accTime >= self.totalTime then
    self.accTime = 0.0;
    self.curLoopCount=self.curLoopCount+1;
    --LOG(" self.curLoopCount")
    --LOG( self.curLoopCount)
   -- LOG("..................")
    if not self.isLoop then
      local id = self.currentOrder;
      local imagetable = self.textures[self.currentOrder];
      self:_Reset();
      local rgb,alpha;
      if imagetable then
        rgb = imagetable[RGB_INDEX];
        alpha = imagetable[ALPHA_INDEX];
      end  
      return rgb, id, alpha, false;
    end
  end
  
  
  local picOrder = math.floor(self.accTime * self.fps) + self.beginid;
  local texcntLimit = self.texCnt+self.beginid;
  if(picOrder==(texcntLimit) or picOrder>(texcntLimit))
  then
      picOrder = texcntLimit-1;
  end
  

  if self.currentOrder ~= picOrder
  and not self.isLoading then
    self.lastOrder = self.currentOrder;
    self.currentOrder = picOrder;--当前的纹理id
    if self.currentOrder ~= self.nextOrder 
      and not self.textures[self.currentOrder] then
        self.isLoading = true;
        local rgbpath, alphapath = self:_GetFileName(self.currentOrder);
        textureloader:CreateTexture(self.agent, self.callbackindex, self.currentOrder, RGB_INDEX, rgbpath, self.premul, self.keepsource);
        if alphapath then
          textureloader:CreateTexture(self.agent, self.callbackindex, self.currentOrder, ALPHA_INDEX, alphapath, self.premul, self.keepsource);
        end        
    end
    self.nextOrder = self:_GetNextIndex(picOrder);--下一帧纹理id
    if not self.textures[self.nextOrder] then
      self.isLoading = true;
      local rgbpath, alphapath = self:_GetFileName(self.nextOrder);
      textureloader:CreateTexture(self.agent, self.callbackindex, self.nextOrder, RGB_INDEX, rgbpath, self.premul, self.keepsource);
      if alphapath then
        textureloader:CreateTexture(self.agent, self.callbackindex, self.nextOrder, ALPHA_INDEX, alphapath, self.premul, self.keepsource);
      end 
    end
  end
  local imagetable = self.isLoading and self.textures[self.lastOrder] or self.textures[self.currentOrder];
  local rgb,alpha;
  if imagetable then
    rgb = imagetable[RGB_INDEX];
    alpha = imagetable[ALPHA_INDEX];
  end  
  return rgb, picOrder, alpha, true;
end


return AsyncTexture;