local ae = require "apolloengine"
local vc = require "venuscore"
require "utility"

local ImageLoadingService = {}


local MAX_TEXTURE_COUNT = 4


ImageLoadingService.textureQueue = {}
ImageLoadingService.numberQueue = {}
ImageLoadingService.popQueue = {}
ImageLoadingService.popNumberQueue = {}

function ImageLoadingService:Push(path, number)

  local alreadyPushed = false

  --rearrange to latest
  for i = 1, #self.numberQueue do
    if self.numberQueue[i] == number then
      table.insert(self.numberQueue, self.numberQueue[i])
      table.insert(self.textureQueue, self.textureQueue[i])
      table.remove(self.numberQueue, i)
      table.remove(self.textureQueue, i)
      alreadyPushed = true
      break
    end
  end

  if not alreadyPushed then
    --least recently use
    if #self.textureQueue == MAX_TEXTURE_COUNT then
      table.remove(self.numberQueue, 1)
      table.remove(self.textureQueue, 1)
    end

    local tex = ae.TextureEntity()
    tex:PushMetadata(
            ae.TextureFileMetadata(
                    ae.TextureEntity.TU_STATIC,
                    ae.TextureEntity.PF_AUTO,
                    1,
                    false,
                    ae.TextureEntity.TW_CLAMP_TO_BORDER,
                    ae.TextureEntity.TW_CLAMP_TO_BORDER,
                    ae.TextureEntity.TF_LINEAR,
                    ae.TextureEntity.TF_LINEAR,
                    path))
    tex:SetJobType(vc.IJob.JT_SYNCHRONOUS)
    tex:CreateResource()

    table.insert(self.textureQueue, tex)
    table.insert(self.numberQueue, number)

    local popNum = #self.popQueue
    for i = 1, popNum do
      if self.popNumberQueue[1] == number then
        self.popQueue[1]:Resume()
        table.remove(self.popQueue, 1)
        table.remove(self.popNumberQueue, 1)
      else
        table.insert(self.popQueue, self.popQueue[1])
        table.insert(self.popNumberQueue, self.popNumberQueue[1])
        table.remove(self.popQueue, 1)
        table.remove(self.popNumberQueue, 1)
      end
    end
  end
end

function ImageLoadingService:Pop(number)

  for i = 1, #self.numberQueue do
    if self.numberQueue[i] == number then
      --LOG("ImageLoadingService:Pop cache hit: " .. tostring(number))
      return self.textureQueue[i]
    end
  end

  LOG("ImageLoadingService:Pop cache missed: " .. tostring(number))

  local context = vc.Context:GetServiceContext()
  table.insert(self.popQueue, context)
  table.insert(self.popNumberQueue, number)
  context:Pasue()

  for i = 1, #self.numberQueue do
    if self.numberQueue[i] == number then
      return self.textureQueue[i]
    end
  end

  return nil

end

function ImageLoadingService:Clear()
  self.textureQueue = {}
  self.numberQueue = {}

  for i = 1, #self.popQueue do
    self.popQueue[i]:Resume()
  end
  self.popQueue = {}
  self.popNumberQueue = {}

  collectgarbage()
  return true;
end

return ImageLoadingService;