local VirtualNode = require "apolloutility.apollonode.virtualnode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"


--虚拟节点，不包含可渲染的组件
local TransNode = VirtualNode:extend();

function TransNode:new()
  TransNode.super.new(self)
  self.trans = apolloengine.TransformComponent();
  self.node:AttachComponent(self.trans);
end

function TransNode:SetLocalPosition(pos)
  self.trans:SetLocalPosition(pos);
end

function TransNode:SetLocalScale(s)
  self.trans:SetLocalScale(s);
end

function TransNode:SetLocalRotation(r)
  self.trans:SetLocalRotation(r);
end

function TransNode:GetLocalPosition()
  return self.trans:GetLocalPosition();
end

function TransNode:GetLocalScale()
  return self.trans:GetLocalScale();
end

function TransNode:GetLocalRotation()
  return self.trans:GetLocalRotation();
end

function TransNode:GetWorldTransform()
  return self.trans:GetWorldTransform();
end

function TransNode:GetWorldScale()
  return self.trans:GetWorldScale();
end

function TransNode:GetWorldPosition()
  return self.trans:GetWorldPosition();
end

function TransNode:GetWorldScale()
  return self.trans:GetWorldScale();
end

function TransNode:GetWorldRotation()
  return self.trans:GetWorldRotation();
end


function TransNode:RigidBodyComponent(shape , mass)
  if not self.rigid then
    self.rigid = apolloengine.RigidBodyComponent();
    self.rigid:Initialize(shape,mass);
    self.node:AttachComponent(self.rigid);
  end
end

function TransNode:SpringJointComponent(node, anchor)
  if not self.rigid then
    error("sprint need rigid component");
  elseif not self.spring then
    self.spring = apolloengine.SpringJointComponent();
    self.node:AttachComponent(self.spring);
    if anchor then
      self.spring:ConnectBody(node.node, anchor);
    else
      self.spring:ConnectBody(node.node);
    end    
  end
end

return TransNode;