local TransNode = require "apolloutility.apollonode.trasnnode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

--骨骼与动画节点
local SkeletonNode = TransNode:extend();

function SkeletonNode:new()
    SkeletonNode.super.new(self);
    self.skeleton = apolloengine.SkeletonComponent();
    self.node:AttachComponent(self.skeleton);
    self.animations = nil;
end

function SkeletonNode:SetSkeletonAndAnims(skeletonpath,aniInfo)
    self.skeleton:PushMetadata(apolloengine.SkeletonAnimationFileMetaData(aniInfo.hasscale and 0 or 1,skeletonpath,aniInfo.name));
    self.skeleton:CreateResource();
    --set default interval
    self.skeleton:SetAnimationInterval(0,aniInfo.framecount-1);
    self.framcount = aniInfo.framecount;
end

function SkeletonNode:UpdateAnimation(def)
    return self.skeleton:UpdateAnimation(def);
end

function SkeletonNode:SetLoop(loop)
    self.skeleton:Loop(loop);
end

function SkeletonNode:Reset(frame)
if frame then
    self.skeleton:Reset(frame)
else
    self.skeleton:Reset()
end  
end

function SkeletonNode:Play()
    self.skeleton:Play()
end

function SkeletonNode:Stop()
    self.skeleton:Stop()
end

function SkeletonNode:SetAnimationInterval(from,to)
    if from < 0 then
        from = 0;
    end

    if to > self.framcount-1 then
        to = self.framcount-1;
    end
    self.skeleton:SetAnimationInterval(from,to);
end

function SkeletonNode:GetFrameCount()
    return self.framcount;
end

function SkeletonNode:AttachNodeToJoint(jointName,node)
    self.skeleton:AttachNodeToJoint(jointName,node);
end

return SkeletonNode;