local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local Object = require "classic"

--虚拟节点，不包含可渲染的组件
local PostEffect = Object:extend();

function PostEffect:new()
  self.post = apolloengine.PostEffectEntity();
end

function PostEffect:GetPostEffect()
  return self.post;
end

function PostEffect:CreateResource(scriptpath)
  self.post:PushMetadata(
    apolloengine.PathMetadata(scriptpath));
  return self.post:CreateResource();  
end

function PostEffect:_RegisterParameter(slotname)
  local ps = apolloengine.IMaterialSystem:GetParameterSlot(slotname);
  local objs = self.post:GetRenderObject()
  for _, roe in pairs(objs) do
    if roe:hasParameter(ps) then
      self[slotname] = function(self, value)
        roe:SetParameter(ps, value);
      end
      return
    end
  end
  self[slotname] = function(self, value)
    local venustype = nil
    if type(value) == "number" then
      venustype = venuscore.Double(value);
    elseif type(value) == "boolean" then
      venustype = venuscore.Bool(value);
    elseif type(value) == "string" then
      venustype = venuscore.String(value);
    elseif type(value) == "userdata" then
      venustype = value;
    else
      error("Unsupported type")
    end    
    self.post:SetParameter(slotname, venustype);
  end
end


function PostEffect:_RegisterParameterWithMaterial(slotname, material)
  local ps = apolloengine.IMaterialSystem:GetParameterSlot(slotname);
  local roe = self.post:GetRenderObject(material);
  self[slotname] = function(self, value)
    roe:SetParameter(ps, value);
  end  
end

function PostEffect:RegisterParameter(slotname, material)
  if material then
    self:_RegisterParameterWithMaterial(slotname, material);
  else
    self:_RegisterParameter(slotname);
  end  
end

function PostEffect:Enable()
  self.post:Enable();
end

function PostEffect:Disable()
  self.post:Disable();
end

function PostEffect:SetQueue(queue)
  self.post:SetQueue(queue);
end


return PostEffect;