local rendernode = require "apolloutility.apollonode.rendernode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"


local PointNode = rendernode:extend();

function PointNode:new()
  PointNode.super.new(self);
  self.vertexstream = apolloengine.VertexStream();--创建顶点流
  self.render:EraseRenderProperty(apolloengine.RenderObjectEntity.RP_CULL);
end


--传入圆心偏移，点的数量，材质，来创建一个可渲染的圆
function PointNode:CreateResource(count, color, material)
  
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,4);
  self.vertexstream:ReserveBuffer(count);--预先分配顶点的内存
  
  --初始化顶点
  for i=1, count do
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector4(0,0,0,0));
  end  

  local res = PointNode.super.CreateResource(self,
    material,
    apolloengine.RenderObjectEntity.RM_POINTS,
    self.vertexstream);
  
  self:SetParameter(
    apolloengine.ShaderEntity.POINT_COLOR,
    color);
  return res;
end

function PointNode:Update(points_table)
  local newpoint =  mathfunction.vector4(0, 0, 0, 1);
  local index = self.vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_POSITION);
  for i=1, #points_table do
    local point = points_table[i];
    newpoint:Set(point[1], point[2], 0, 1);
    self.vertexstream:ChangeVertexDataWithAttributeFast(
      index,
      i,
      newpoint);
  end
  self.vertexstream:SetReflushInterval(1, #points_table);
  self.render:ChangeVertexBuffer(self.vertexstream);
end

return PointNode;