local RenderNode = require "apolloutility.apollonode.rendernode"
local defiend = require "apolloutility.defiend"
local mathfunction = require "mathfunction"
local apologine = require "apolloengine"
local venusjson = require "venusjson"



--初始化内部用到的shader slot
apologine.IMaterialSystem:NewParameterSlot(apologine.ShaderEntity.INTERNAL,"COLOR_ALPHA");
apologine.IMaterialSystem:NewParameterSlot(apologine.ShaderEntity.INTERNAL,"EMITTER_AGE");
apologine.IMaterialSystem:NewParameterSlot(apologine.ShaderEntity.INTERNAL,"PARTICLE_COLOR");
apologine.IMaterialSystem:NewParameterSlot(apologine.ShaderEntity.INTERNAL,"PARTICLE_OFFEET");
apologine.IMaterialSystem:NewParameterSlot(apologine.ShaderEntity.INTERNAL,"PARTICLE_SPEED");
apologine.IMaterialSystem:NewParameterSlot(apologine.ShaderEntity.INTERNAL,"PARTICLE_STRETCH");
local globaloffsetslot = apologine.IMaterialSystem:NewParameterSlot(apologine.ShaderEntity.UNIFORM,"PARTICLE_GLOBAL_OFFSET");
local globalscaleslot = apologine.IMaterialSystem:NewParameterSlot(apologine.ShaderEntity.UNIFORM, "PARTICLE_GLOBAL_SCALE");

local ParticleNode = RenderNode:extend();


local particle_material_begin = [[
                            #include "comm:documents/material/shaders/billboardtransform.shader"
                            #include "comm:documents/material/shaders/emittersoftinout.shader"
                            #include "comm:documents/material/shaders/emitteroutputs.shader"
                            #include "comm:documents/material/shaders/emitterspeed.shader"
                            #include "comm:documents/material/shaders/emitterstretch.shader"
                            #include "comm:documents/material/shaders/emittersize.shader"
                            #include "comm:documents/material/shaders/emitterage.shader"
                            #include "comm:documents/material/shaders/emittercolor.shader"
                            #include "comm:documents/material/shaders/transform.shader"
                            #include "comm:documents/material/shaders/emitteruv.shader"
                            #include "comm:documents/material/shaders/sampling.shader"
                            #include "comm:documents/material/shaders/outputs.shader"  
                            #include "comm:documents/material/shaders/emitter_stretch.shader"
                            #include "comm:documents/material/shaders/emittervertex_cpu.shader"
                            #include "comm:documents/material/shaders/emitterfragmet_cpu.shader"
 
                                                                             
                             #LIGHTING_AMBIENT_FORWARD_SINGLE		SimpleParticle 
                             #LIGHTING_DIRECTION_FORWARD_SINGLE			SimpleParticle 
                             #LIGHTING_POINT_FORWARD_SINGLE 			SimpleParticle 
                             #LIGHTING_SPOT_FORWARD_SINGLE 			SimpleParticle 
                                                                                
                             #MATERIAL_DEFINE SimpleParticle 
	                            RENDER_QUEUE = TRANSPARENT 
	                            COLOR_MASK = COLOR_RGBA 
	                            ALPAH_MODE = %s
	                            DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS } 
	                            STENCIL_MODE = {STENCIL_OFF}]];
local defualt_alpha_mode = "{ ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA , SRC_ALPHA, ONE }";
local particle_material_end = "#END_DEFINE";

function ParticleNode:new()
  self.isshow = true;
  --self.particlemodifier = apologine.ParticleModifier();
  self.parameters = {};
  self.textures = {}
  self.passes = {}
  self.globaloffset = mathfunction.vector3(0.0,0.0,0.0);
  self.globalscale = mathfunction.vector3(1.0,1.0,1.0);
  self.globaloffsetslot = globaloffsetslot;

end

function ParticleNode:SetGlobalOffset(offset)
  --create resource之前设置和之后设置处理不一样
  self.globaloffset = offset;
  if self.render ~= nil then
    self.render:SetParameter(globaloffsetslot,offset);
  end
end

function ParticleNode:SetGlobalScale(scale)
  self.globalscale = scale;
  if self.render ~= nil then
    self.render:SetParameter(globalscaleslot,scale);
  end
end

function ParticleNode:Reset()
  self.node:Reset();
end



function ParticleNode:SetSpwanAndLifeType(spwantype,lifetype)
  if spwantype == nil or lifetype == nil then
    return;
  end
  local spwantypeenum = self:GetParamEnum(spwantype);
  local lifetypeenum = self:GetParamEnum(lifetype);
  self.node:SetSpwanType(spwantypeenum);
  self.node:SetLifeType(lifetypeenum);
end

function ParticleNode:ParseAffector(affectvalue)
  local affecttype = affectvalue.Affect;
  local affector = self.node:CreateAffector(affecttype);
  if affecttype == 21 then  --序列帧动画
    self:ParseAnimationAffector(affector,affectvalue);
  elseif affecttype == 22 then
    self:ParseSphereAffector(affector,affectvalue);
  elseif affecttype == 23 then
    self:ParseConeAffector(affector,affectvalue);
  elseif affecttype == 26 then
    self:ParseSphereAffector(affector,affectvalue);
  elseif affecttype == 24 then
    self:ParseBoxAffector(affector,affectvalue);
  else
    self:ParseGeneralAffector(affector,affectvalue);
  end
end

function ParticleNode:ParseAnimationAffector(affector,affectvalue)
  local tiles = mathfunction.vector2(affectvalue.Tiles[1],affectvalue.Tiles[2]);
  local cycles = affectvalue.Cycles;
  local animMode = affectvalue.AnimationMode;
  local animRow = affectvalue.Row;
  local bConstantFrame = affectvalue.IsConstantFrame;
  local constantFrame = affectvalue.ConstantFrame;
  local startFrame = affectvalue.StartFrame;
          
  affector:SetTiles(tiles);
  affector:SetMode(animMode);
  affector:SetCycles(cycles);
          
  if animMode ~= 0 and animRow~= nil then   --SingleRow 模式
    local rowMin = mathfunction.vector1(affectvalue.Row.Min.n);
    local rowMax = mathfunction.vector1(affectvalue.Row.Max.n);
    local rowDatatype = affectvalue.Row.DataType;
    affector:SetRow(rowDatatype,rowMin,rowMax);
  end
  if bConstantFrame == true and constantFrame ~= nil then
    local frameMin = mathfunction.vector1(constantFrame.Min.n);
    local frameMax = mathfunction.vector1(constantFrame.Max.n);
    local frameDatatype = constantFrame.DataType;
    affector:SetConstantFrame(frameDatatype,frameMin,frameMax);
  end
  if startFrame ~= nil then
    local startMin = mathfunction.vector1(startFrame.Min.n);
    local startMax = mathfunction.vector1(startFrame.Max.n);
    local startDatatype = startFrame.DataType;
    affector:SetStartFrame(startDatatype,startMin,startMax);
  end
end

function ParticleNode:ParseGeneralAffector(affector,affectvalue)
  local datatype = affectvalue.DataType;
  local min;
  local max;
  local bConstant = false;
  if datatype == 0 then  --vector1f
    bConstant = affectvalue.Constant;
    if bConstant == nil then
      bConstant = false;
    end
    if bConstant then
      min = mathfunction.vector1(affectvalue.Value[1]);
      max = min;
    else
      min = mathfunction.vector1(affectvalue.Min.n);
      max = mathfunction.vector1(affectvalue.Max.n);
    end
  end
  if datatype == 1 then  --vector2f
    bConstant = affectvalue.Constant;
    if bConstant == nil then
      bConstant = false;
    end
    if bConstant then
      min = mathfunction.vector2(affectvalue.Value[1],affectvalue.Value[2]);
      max = min;
    else
      min = mathfunction.vector2(affectvalue.Min.x,affectvalue.Min.y);
      max = mathfunction.vector2(affectvalue.Max.x,affectvalue.Max.y);
    end
  end
  if datatype == 2 then  --vector3f
    bConstant = affectvalue.Constant;
    if bConstant == nil then
      bConstant = false;
    end
    if bConstant then
      min = mathfunction.vector3(affectvalue.Value[1],affectvalue.Value[2],affectvalue.Value[3]);
      max = min;
    else
      min = mathfunction.vector3(affectvalue.Min.x,affectvalue.Min.y,affectvalue.Min.z);
      max = mathfunction.vector3(affectvalue.Max.x,affectvalue.Max.y,affectvalue.Max.z);
    end
  end
  if datatype == 3 then  --vector4f
    bConstant = affectvalue.Constant;
    if bConstant == nil then
      bConstant = false;
    end
    if bConstant then
      min = mathfunction.vector4(affectvalue.Value[1],affectvalue.Value[2],affectvalue.Value[3],affectvalue.Value[4]);
      max = min;
    else
      min = mathfunction.vector4(affectvalue.Min.x,affectvalue.Min.y,affectvalue.Min.z,affectvalue.Min.w);
      max = mathfunction.vector4(affectvalue.Max.x,affectvalue.Max.y,affectvalue.Max.z,affectvalue.Max.w);
    end
  end
  affector:SetRange(datatype,min,max);
end

function ParticleNode:ParseSphereAffector(affector, affectvalue)
  local center = mathfunction.vector3(affectvalue.Center[1],affectvalue.Center[2],affectvalue.Center[3]);
  local radius = affectvalue.Radius;
  local emitterfromshell = affectvalue.EmitterFromShell;
  
  affector:SetCenter(center);
  affector:SetRadius(radius);
  affector:SetEmitterFromShell(emitterfromshell);
end

function ParticleNode:ParseConeAffector(affector, affectvalue)
  local center = mathfunction.vector3(affectvalue.Center[1],affectvalue.Center[2],affectvalue.Center[3]);
  local radius = affectvalue.Radius;
  local length = affectvalue.Length;
  local angle = affectvalue.Angle;
  local emittermode = affectvalue.EmitterFrom;
  
  affector:SetCenter(center);
  affector:SetRadius(radius);
  affector:SetLength(length);
  affector:SetAngle(angle);
  affector:SetEmitterFromMode(emittermode);
end

function ParticleNode:ParseBoxAffector(affector, affectvalue)
  local center = mathfunction.vector3(affectvalue.Center[1],affectvalue.Center[2],affectvalue.Center[3]);
  local width = affectvalue.Width;
  local height = affectvalue.Height;
  local depth = affectvalue.Depth;
  local emittermode = affectvalue.EmitterFrom;
  affector:SetCenter(center);
  affector:SetWidth(width);
  affector:SetHeight(height);
  affector:SetDepth(depth);
  affector:SetEmiterFromMode(emittermode);
end


function ParticleNode:ParseCircleAffector(affector, affectvalue)
  local center = mathfunction.vector3(affectvalue.Center[1],affectvalue.Center[2],affectvalue.Center[3]);
  local radius = affectvalue.Radius;
  local emitterfromshell = affectvalue.EmitterFromShell;
  
  affector:SetCenter(center);
  affector:SetRadius(radius);
  affector:SetEmitterFromShell(emitterfromshell);
end


function ParticleNode:CreateResource(config)
  local particleconfig = venusjson.LaodJsonFile(config);
  local rootpath = string.match(config, "(.+)/[^/]*%.%w+$");
  local emittertype = particleconfig.Type;
  local spwantype = particleconfig.SpwanType;
  local lifetype = particleconfig.LifeType;
  local particlewidth = particleconfig.ParticleWidth;
  local particleheight = particleconfig.ParticleHeight;
  local particledata = particleconfig.Data;
  local particleModifier = nil;
  
  if emittertype == "CPU" then
    self.node = apologine.CPUEmitter();
    self.particlemodifier = self.node:AddModifier();  --增加一个更新(只对CPU粒子有效)
    self.emittertype = 1; --GPU EMITTER
  end
  
  if emittertype == "GPU" then
    self.node = apologine.GPUEmitter();
    self.emittertype = 2; --CPU EMITTER
  end
  
  self.render = self.node:GetRenderComponent();
  self.trans = self.node:GetTransformComponent();
  self:SetSpwanAndLifeType(spwantype,lifetype);
  if particlewidth ~= nil then
    self.node:SetParticleWidth(particlewidth);
  end
  if particleheight ~= nil then
    self.node:SetParticleHeight(particleheight);
  end
  
  
  for datakey, datavalue in pairs(particledata) do
    if datakey == "Transform" then
      local localscale = datavalue.LocalScale
      local scalevalue = mathfunction.vector3(localscale.x,localscale.y,localscale.z);
      local localposition = datavalue.LocalPosition;
      local posvalue = mathfunction.vector3(localposition.x,localposition.y,localposition.z);
      local localrotation = datavalue.LocalRotation;
      local rotvalue = mathfunction.Quaternion(localrotation.x,localrotation.y,localrotation.z,localrotation.w);
      self:SetLocalPosition(posvalue);
      self:SetLocalScale(scalevalue);
      self:SetLocalRotation(rotvalue);
    end
    if datakey == "Affector" then
      for _,affectvalue in pairs(datavalue) do
        self:ParseAffector(affectvalue);  --解析affector
      end
    end
    if datakey == "Textures" then
      for _, texValue in pairs(datavalue) do
        local texturepath = texValue.Path;
        local textureslot = texValue.Slot;
        local texture_ = {textureslot,texturepath};
        table.insert(self.textures,texture_);  --保存所有texture
          --self.node:PushTextureMetadata(apologine.ShaderEntity.TEXTURE_DIFFUSE,texturepath);
      end
    end
    if datakey == "Pass" then
      for _, passValue in pairs(datavalue) do
        local passtype = passValue.Type;  --区分type类型
        local textureindex = passValue.TextureIndex; --输入纹理
        local parameters = passValue.Parameters;  --uniforms
        local inputpass = passValue.InputPass;  --承接的上次渲染结果
        local vertertparts = passValue.VertexShaderParts;  --vertert shader
        local fragmentparts = passValue.FragmentShaderParts;  --fragment shader
        local pass_ = {passtype, textureindex,parameters,vertertparts,fragmentparts};
        table.insert(self.passes,pass_);
      end
    end
  end
  
  --材质拼装
  self:SetupMaterial(rootpath, particledata.AlphaMode);
  self:SetupUniforms();
  
end

function ParticleNode:SetParameter(slot,value)
  local parameter = {slot,value};
  table.insert(self.parameters,parameter);
end

function ParticleNode:PushTextureMetadata(slot, imagepath)
  self.render:PushMetadata(--传入纹理原始数据
    apologine.RenderObjectTextureMetadata(
      apologine.ShaderEntity.TEXTURE_DIFFUSE + slot,
      apologine.TextureFileMetadata(
        apologine.TextureEntity.TU_STATIC,
        apologine.TextureEntity.PF_AUTO,
        1, true,
        apologine.TextureEntity.TW_CLAMP_TO_EDGE,
        apologine.TextureEntity.TW_CLAMP_TO_EDGE,
        apologine.TextureEntity.TF_LINEAR,
        apologine.TextureEntity.TF_LINEAR_MIPMAP_LINEAR,
        imagepath)));
end

function ParticleNode:PushMaterialMetadata(materialsrc)
   self.render:PushMetadata(
    apologine.RenderObjectMaterialMetadata(
      apologine.StringBufferMetadata(materialsrc)));
end

function ParticleNode:GetParamEnum(paramName)
  if paramName == "Alpha" then
    return apologine.ParticleModifier.PARAM_ALPHA;
  elseif paramName == "Angle" then
    return apologine.ParticleModifier.PARAM_ANGLE;
  elseif paramName == "AngularVelocity" then
    return apologine.ParticleModifier.PARAM_ANGULAR_VELOCITY;
  elseif paramName == "Damping" then
    return apologine.ParticleModifier.PARAM_DAMPING;
  elseif paramName == "Hue" then
    return apologine.ParticleModifier.PARAM_HUE;
  elseif paramName == "Brightness" then
    return apologine.ParticleModifier.PARAM_BRIGHTNESS;
  elseif paramName == "Saturation" then
    return apologine.ParticleModifier.PARAM_SATURATION;
  elseif paramName == "Color" then
    return apologine.ParticleModifier.PARAM_COLOR;
  elseif paramName == "LinearVelocity" then
    return apologine.ParticleModifier.PARAM_LINEAR_VELOCITY;
  elseif paramName == "LinearAccel" then
    return apologine.ParticleModifier.PARAM_LINEAR_ACCEL;
  elseif paramName == "RadialAccel" then
    return apologine.ParticleModifier.PARAM_RADIAL_ACCEL;
  elseif paramName == "Scale" then
    return apologine.ParticleModifier.PARAM_SCALE;
  elseif paramName == "TangentAccel" then
    return apologine.ParticleModifier.PARAM_TANGENTAL_ACCEL;
  elseif paramName == "Stretch" then
    return apologine.ParticleModifier.PARAM_STRETCH;
  elseif paramName == "RotX" then
    return apologine.ParticleModifier.PARAM_ROT_X;
  elseif paramName == "RotY" then
    return apologine.ParticleModifier.PARAM_ROT_Y;
  elseif paramName == "RotZ" then
    return apologine.ParticleModifier.PARAM_ROT_Z;
  elseif paramName == "ForceX" then
    return apologine.ParticleModifier.PARAM_EXTERNAL_FORCE_X;
  elseif paramName == "ForceY" then
    return apologine.ParticleModifier.PARAM_EXTERNAL_FORCE_Y;
  elseif paramName == "ForceZ" then
    return apologine.ParticleModifier.PARAM_EXTERNAL_FORCE_Z;
  elseif paramName == "Distrubance" then
    return apologine.ParticleModifier.PARAM_VERTEX_DISTURBANCE;
  elseif paramName == "Linear" then
    return apologine.ParticleModifier.TANGENT_LINEAR;
  elseif paramName == "Free" then
    return apologine.ParticleModifier.TANGENT_FREE;
  elseif paramName == "OneShot" then
    return apologine.IParticleEmitter.ONE_SHOT;
  elseif paramName == "OneShotLoop" then
    return apologine.IParticleEmitter.ONE_SHOT_LOOP;
  elseif paramName == "Continus" then
    return apologine.IParticleEmitter.CONTINUS;
  elseif paramName == "Normal" then
    return apologine.IParticleEmitter.LT_NORMAL;
  elseif paramName == "Loop" then
    return apologine.IParticleEmitter.LT_LOOP;
  elseif paramName == "Live" then
    return apologine.IParticleEmitter.LT_LIVE;
  elseif paramName == "AnimationFrame" then
    return apologine.ParticleModifier.PARAM_ANIMATION_FRAME;
  else
    return nil;
  end
end

function ParticleNode:SetupMaterial(rootpath, alphamode)
  --多个pass的承接怎么做?
  for _, pass in pairs(self.passes) do
    local textureindexes = pass[2];
    local parameters = pass[3];
    local vertexparts = pass[4];
    local fragmentparts = pass[5];
    
    --push texture metadata
    for _,textureindex in pairs(textureindexes) do
      local texture = self.textures[textureindex];
      if texture ~= nil then
        self:PushTextureMetadata(texture[1], rootpath.."/"..texture[2]);
      end
    end
    
    if self.emittertype == 1 then  --cpu emitter
      for _, param in pairs(parameters) do
        local paramName = param.Name;
        local paramenum = self:GetParamEnum(paramName);
        local paramData = param.Data;
        
        if paramenum == apologine.ParticleModifier.PARAM_COLOR then
          for _, paramdata in pairs(paramData) do
            local paramtype = paramdata.Type;
            if paramtype == "Gradient" then
              self.particlemodifier:AddColorGradient();
              local gradientdata = paramdata.Value;
              for _, pointdata in pairs(gradientdata) do
                local offset = pointdata.Offset;
                local color = mathfunction.vector3(pointdata.Value[1],pointdata.Value[1],pointdata.Value[1]);
                self.particlemodifier:AddColorPoint(offset,color);
              end
            end
          end
        else
          for _, paramdata in pairs(paramData) do
            local paramdatatype = paramdata.Type;
            if paramdatatype == "Curve" then   --曲线类型参数
              self.particlemodifier:AddCurveParameter(paramenum);
              local curvedata = paramdata.Value;
              for _, pointdata in pairs(curvedata) do
                local left_tangent = pointdata.Left_tangent;
                local left_mode = pointdata.Left_mode;
                local left_mode_enum = self:GetParamEnum(left_mode);
                local right_tangent = pointdata.Right_tangent;
                local right_mode = pointdata.Right_mode;
                local right_mode_enum = self:GetParamEnum(right_mode);
                local point = mathfunction.vector2(pointdata.Point[1],pointdata.Point[2]);
                self.particlemodifier:AddCurvePoint(paramenum,point,left_tangent,right_tangent,left_mode_enum,right_mode_enum);
              end
            end
            if paramdatatype == "Base" then    --常量类型参数
              local basevalue = paramdata.Value;
              self.particlemodifier:SetParameter(paramenum,basevalue);
            end
            if paramdatatype == "Random" then   ---随机参数
              local randomvalue = paramdata.Value;
              self.particlemodifier:SetParameterRandomess(paramenum,randomvalue);
            end
            if paramdatatype == "Gravity" then
              local gravity = mathfunction.vector3(paramdata.Value[1],paramdata.Value[2],paramdata.Value[3]);
              self.particlemodifier:SetGravity(gravity);
            end
          end
        end
      end
    end
  
    if self.emittertype == 2 then  --gpu emitter
      for _, uniform in pairs(parameters) do
        local uniformname = uniform.Name;
        if uniformname ~= nil then
          local slot = apologine.IMaterialSystem:NewParameterSlot(apologine.ShaderEntity.UNIFORM,uniformname);
          local datatype = uniform.DataType;
          if datatype == "Float" then
            local value = mathfunction.vector1(uniform.Value[1]);
            self:SetParameter(slot,value);
          end
          if datatype == "Vec2" then
            local value = mathfunction.vector2(uniform.Value[1],uniform.Value[2]);
            self:SetParameter(slot,value);
          end
          if datatype == "Vec3" then
            local value = mathfunction.vector3(uniform.Value[1],uniform.Value[2],uniform.Value[3]);
            self:SetParameter(slot,value);
          end
          if datatype == "Vec4" then
            local value = mathfunction.vector4(uniform.Value[1],uniform.Value[2],uniform.Value[3],uniform.Value[4]);
            self:SetParameter(slot,value);
          end
          if datatype == "Mat3" then
            
          end
          if datatype == "Mat4" then
          
          end
        end
      end
    end
    --material metadata
    local material_begin = string.format(particle_material_begin, alphamode or defualt_alpha_mode);
    
    local materialsrc = material_begin .. "\nVERTEX_SHADER = {\n";
    for _,  vertexpart in pairs(vertexparts) do
      materialsrc = materialsrc .. "\"" .. vertexpart .. "\",\n";
    end
    materialsrc = materialsrc .. "}\n";
    materialsrc = materialsrc .. "FRAGMENT_SHADER = {\n";
    for _, fragmentpart in pairs(fragmentparts) do
      materialsrc = materialsrc .. "\"" .. fragmentpart .. "\",\n";
    end
    materialsrc = materialsrc .. "}\n";
    materialsrc = materialsrc .. particle_material_end;
    self:PushMaterialMetadata(materialsrc);
  end
  
end

function ParticleNode:SetupUniforms()
  
  self.render:EraseRenderProperty(apologine.RenderObjectEntity.RP_SHOW);
  self.node:CreateResource();
  --create resource 之后才能设置参数
  --设置uniform参数
  for _,value in pairs(self.parameters) do
    self.render:SetParameter(value[1],value[2]);
  end
  self.render:SetParameter(globaloffsetslot,self.globaloffset);
  self.render:SetParameter(globalscaleslot,self.globalscale);
  self.render:SetRenderProperty(apologine.RenderObjectEntity.RP_SHOW);
end


function ParticleNode:Update(span)
  if self.node ~= nil then
      self.node:Update(span);
  end
end

function ParticleNode:AsyncUpdate(span)
  self:Update(span);
end

function ParticleNode:Start()
  if self.node~= nil then
    self.node:Start();
  end
end

function ParticleNode:Stop()
  if self.node~= nil then
    self.node:Stop();
  end
end

function ParticleNode:Enable()
  if self.node~= nil then
    self.node:Enable();
  end
end

function ParticleNode:Disable()
  if self.node~= nil then
    self.node:Disable();
  end
end


function ParticleNode:CreateEmitter(emitterType)
  if emitterType == "CPU" then
    self.node = apologine.CPUEmitter();
    self.particlemodifier = self.node:AddModifier();  --增加一个更新(只对CPU粒子有效)
    self.emittertype = 1; --GPU EMITTER
  elseif emitterType == "GPU" then
    self.node = apologine.GPsUEmitter();
    self.emittertype = 2; --CPU EMITTER
  else
    self.node = apologine.CPUEmitter();
    self.particlemodifier = self.node:AddModifier();  --增加一个更新(只对CPU粒子有效)
    self.emittertype = 1; --GPU EMITTER
  end
  self.render = self.node:GetRenderComponent();
  self.trans = self.node:GetTransformComponent();
end

function ParticleNode:Reset()
  self.node:Reset();
end

function ParticleNode:AddGeneralAffector(affType,datatype,min,max)
  local affector = self.node:CreateAffector(affType);
  affector:SetRange(datatype,min,max);
  return affector;
end

function ParticleNode:AddAnimationAffector(tiles,cycles,animMode,minRow,maxRow,bConstantFrame,minConstantFrame,maxConstantFrame,minStartFrame,maxStartFrame)
  
  local affector = self.node:CreateAffector(21);

  affector:SetTiles(tiles);
  affector:SetMode(animMode);
  affector:SetCycles(cycles);
          
  if animMode ~= 0 and minRow~= nil and maxRow ~= nil then   --SingleRow 模式
    local rowMin = mathfunction.vector1(minRow);
    local rowMax = mathfunction.vector1(maxRow);
    local rowDatatype = 0;
    affector:SetRow(rowDatatype,rowMin,rowMax);
  end
  if bConstantFrame == true and minConstantFrame ~= nil and maxConstantFrame ~= nil then
    local frameMin = mathfunction.vector1(minConstantFrame);
    local frameMax = mathfunction.vector1(maxConstantFrame);
    local frameDatatype = 0;
    affector:SetConstantFrame(frameDatatype,frameMin,frameMax);
  end
  if minStartFrame ~= nil and maxStartFrame ~= nil then
    local startMin = mathfunction.vector1(minStartFrame);
    local startMax = mathfunction.vector1(maxStartFrame);
    local startDatatype = 0;
    affector:SetStartFrame(startDatatype,startMin,startMax);
  end
  return affector;
end

function ParticleNode:AddSphereShapeAffector(center,radius,emittfromshell)
  local affector = self.node:CreateAffector(22);
  affector:SetCenter(center);
  affector:SetRadius(radius);
  affector:SetEmitterFromShell(emittfromshell);
  return affector;
end

function ParticleNode:AddConeShapeAffector(center,radius,angle,length,arcangle,emitmode)
  local affector = self.node:CreateAffector(23)
  affector:SetCenter(center);
  affector:SetRadius(radius);
  affector:SetLength(length);
  affector:SetAngle(angle);
  affector:SetArcAngle(arcangle);
  affector:SetEmitterFromMode(emitmode);
  return affector;
end

function ParticleNode:AddBoxShapeAffector(center,x,y,z,emitmode)
  local affector = self.node:CreateAffector(24);
  affector:SetCenter(center);
  affector:SetWidth(x);
  affector:SetHeight(y);
  affector:SetDepth(z);
  affector:SetEmiterFromMode(emitmode);
  return affector;
end

function ParticleNode:AddHemiSphereShapeAffector(center,radius,emitfromshell)
  local affector = self.node:CreateAffector(26);
  affector:SetCenter(center);
  affector:SetRadius(radius);
  affector:SetEmitterFromShell(emitfromshell);
  return affector;
end

function ParticleNode:AddCircleShapeAffector(center,radius,emitfromshell)
  local affector = self.node:CreateAffector(26);
  affector:SetCenter(center);
  affector:SetRadius(radius);
  affector:SetEmitterFromShell(emitfromshell);
  return affector;
end


function ParticleNode:SetGravity(gravity)
  self.particlemodifier:SetGravity(gravity);
end

function ParticleNode:AddCurve(paramName)
  local paramenum = self:GetParamEnum(paramName);
  self.particlemodifier:AddCurveParameter(paramenum);
end

function ParticleNode:GetCurvePointCount(paramname)
  local paramenum = self:GetParamEnum(paramname);
  return self.particlemodifier:GetPointsCount(paramenum);
end

function ParticleNode:GetCurveLeftTangentMode(paramname,index)
  local paramenum = self:GetParamEnum(paramname);
  return self.particlemodifier:GetPointLeftTangentMode(paramenum,index);
end

function ParticleNode:SetCurveLeftTangentMode(paramname,index, mode)
  local paramenum = self:GetParamEnum(paramname);
  local modeenum = self:GetParamEnum(mode);
  self.particlemodifier:SetPointLeftTangentMode(paramenum,index,modeenum);
end

function ParticleNode:GetCurveRightTangentMode(paramname, index)
  local paramenum = self:GetParamEnum(paramname);
  return self.particlemodifier:GetPointRightTangentMode(paramenum,index);
end

function ParticleNode:SetCurveRightTangentMode(paramname,index,mode)
  local paramenum = self:GetParamEnum(paramname);
  local modeenum = self:GetParamEnum(mode);
  self.particlemodifier:SetPointRightTangentMode(paramenum,index,modeenum);
end

function ParticleNode:GetCurveLeftTangentValue(paramname,index)
  local paramenum = self:GetParamEnum(paramname);
  return self.particlemodifier:GetPointLeftTangent(paramenum,index);
end

function ParticleNode:SetCurveLeftTangentValue(paramname,index,value)
  local paramenum = self:GetParamEnum(paramname);
  self.particlemodifier:SetPointLeftTangent(paramenum,index,value);
end


function ParticleNode:SetRandomBetween(paramname,min,max)
  local paramenum = self:GetParamEnum(paramname);
  self.particlemodifier:SetRandomBetween(paramenum,min,max);
end

function ParticleNode:GetCurveRightTangentValue(paramname,index)
  local paramenum = self:GetParamEnum(paramname);
  return self.particlemodifier:GetPointRightTangent(paramenum,index);
end

function ParticleNode:SetCurveRightTangentValue(paramname,index,value)
  local paramenum = self:GetParamEnum(paramname);
  self.particlemodifier:SetPointRightTangent(paramenum,index,value);
end

function ParticleNode:GetCurvePosition(paramname,index)
  local paramenum = self:GetParamEnum(paramname);
  return self.particlemodifier:GetPointPosition(paramenum,index);
end

function ParticleNode:SetCurvePointOffset(paramname,index,offset)
  local paramenum = self:GetParamEnum(paramname);
  self.particlemodifier:SetPointOffset(paramenum,index,offset);
end

function ParticleNode:SetCurvePointValue(paramname,index,value)
  local paramenum = self:GetParamEnum(paramname);
  self.particlemodifier:SetPointValue(paramenum,index,value);
end

function ParticleNode:GetCurvePointIndex(paramname, offset)
  local paramenum = self:GetParamEnum(paramname);
  return self.particlemodifier:GetCurvePointIndex(paramenum,offset);
end

function ParticleNode:Interpolate(paramname, offset)
  local paramenum = self:GetParamEnum(paramname);
  return self.particlemodifier:Interpolate(paramenum,offset);
end


function ParticleNode:RemoveCurve(paramname)
  local paramenum = self:GetParamEnum(paramname);
  self.particlemodifier:RemoveCurveParameter(paramenum);
end

function ParticleNode:RemoveCurvePoint(paramname, index)
  local paramenum = self:GetParamEnum(paramname);
  self.particlemodifier:RemoveCurvePoint(paramenum,index);
end

function ParticleNode:AddCurvePoint(paramName,left_mode,left_tangent,right_mode,right_tangent,point)
  local paramenum = self:GetParamEnum(paramName);
  local left_mode_enum = self:GetParamEnum(left_mode);
  local right_mode_enum = self:GetParamEnum(right_mode);
  self.particlemodifier:AddCurvePoint(paramenum,point,left_tangent,right_tangent,left_mode_enum,right_mode_enum);
end

function ParticleNode:AddColorGradient()
  self.particlemodifier:AddColorGradient();
end

function ParticleNode:RemoveColorGradient()
  self.particlemodifier:RemoveColorGradient();
end

function ParticleNode:GetColorPointCount()
  return self.particlemodifier:GetColorPointCount();
end

function ParticleNode:GetColorPoint(index)
  return self.particlemodifier:GetColorPoint(index);
end

function ParticleNode:GetColorOffset(index)
  return self.particlemodifier:GetColorOffset(index);
end

function ParticleNode:RemoveColorPoint(index)
  self.particlemodifier:RemoveColorPoint(index);
end

function ParticleNode:InterpolateColor(offset)
  return self.particlemodifier:InterpolateColor(offset);
end



function ParticleNode:RemoveColorPoint(index)
  self.particlemodifier:RemoveColorPoint(index);
end

function ParticleNode:AddColorPoint(offset,color)
  self.particlemodifier:AddColorPoint(offset,color);
end

function ParticleNode:SetBaseParam(paramName,baseValue)
  local paramenum = self:GetParamEnum(paramName);
  if paramenum ~= nil and baseValue ~= nil then
      self.particlemodifier:SetParameter(paramenum,baseValue); 
  end
end

function ParticleNode:GetBaseParam(paramName)
  local res = -1;
  local paramenum = self:GetParamEnum(paramName);
  if paramenum ~= nil then
      res = self.particlemodifier:GetParam(paramenum); 
  end
  return res;
end


function ParticleNode:SetRandomParam(paramName, randomValue)
  local paramenum = self:GetParamEnum(paramName);
  if paramenum ~= nil and randomValue ~= nil then
      self.particlemodifier:SetParameterRandomess(paramenum,randomValue);
  end
end

function ParticleNode:GetRandomParam(paramName)
  local res = 0.0;
  local paramenum = self:GetParamEnum(paramName);
  if paramenum ~= nil then
    res = self.particlemodifier:GetParameterRandomness(paramenum);
  end
  return res;
end


function ParticleNode:SetParamMultipiler(paramName,baseValue)
  local paramenum = self:GetParamEnum(paramName);
  if paramenum ~= nil and baseValue ~= nil then
      self.particlemodifier:SetParamMultiplier(paramenum,baseValue); 
  end
end

function ParticleNode:ResetParamMultipiler()
  self.particlemodifier:ResetParamMultiplier(); 
end

function ParticleNode:SetShaderParts(vertexShaderParts,fragmentShaderParts,alphamode)
    --material metadata
    local material_begin = string.format(particle_material_begin, alphamode or defualt_alpha_mode);
    
    local materialsrc = material_begin .. "\nVERTEX_SHADER = {\n";
    for _,  vertexpart in pairs(vertexShaderParts) do
      materialsrc = materialsrc .. "\"" .. vertexpart .. "\",\n";
    end
    materialsrc = materialsrc .. "}\n";
    materialsrc = materialsrc .. "FRAGMENT_SHADER = {\n";
    for _, fragmentpart in pairs(fragmentShaderParts) do
      materialsrc = materialsrc .. "\"" .. fragmentpart .. "\",\n";
    end
    materialsrc = materialsrc .. "}\n";
    materialsrc = materialsrc .. particle_material_end;
    
    self:PushMaterialMetadata(materialsrc);
end

function ParticleNode:SetTexture(texturepath)
  self:PushTextureMetadata(0,texturepath);
end

function ParticleNode:SetUp()
  self:SetupUniforms();
end



return ParticleNode;