local rendernode = require "apolloutility.apollonode.rendernode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

--模型节点
local MeshNode = rendernode:extend();

function MeshNode:new()
  MeshNode.super.new(self)
 
end

function MeshNode:CreateResource(meshpath,materialpath,skeletonPath,animationpath,frameCount,aniType, mu, outline)
  
  --mesh
  if outline ~= nil then
    local materialEntity = self.render:MakeMaterialAttachment();
    materialEntity:PushMetadata(apolloengine.PathMetadata(materialpath));
    apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"INTERNAL_COLOR0");
    local color = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"Main_Color");
    local width = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"EDGE_WIDTH");
    local offscale = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"OFFSET_SCALE");
    
    local minwidth = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"MIN_WIDTH");
    local rangedis = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"RANGE_DISTANCE");
    
    local outlineMaterialEntity = self.render:MakeMaterialAttachment();
    outlineMaterialEntity:PushMetadata(apolloengine.PathMetadata(outline.material)); 
    outlineMaterialEntity:SetParameter(color,mathfunction.vector4(unpack(outline.color)));
    outlineMaterialEntity:SetParameter(width,mathfunction.vector1(outline.width));
    local s = outline.offsetscale and outline.offsetscale or 1;
    
    local mw =  outline.minwidth and outline.minwidth or outline.width/2.0;
    local rs =  outline.rangedis and outline.rangedis or 2.0;
    outlineMaterialEntity:SetParameter(minwidth,mathfunction.vector1(mw));
    outlineMaterialEntity:SetParameter(rangedis,mathfunction.vector1(rs));
    outlineMaterialEntity:SetParameter(offscale,mathfunction.vector1(s));
  else
    self.render:PushMetadata(
      apolloengine.RenderObjectMaterialMetadata(
        apolloengine.PathMetadata(materialpath)));
  end
  
  if mu == nil then
    mu = apolloengine.VertexBufferEntity.MU_STATIC;
  end   

  self.render:PushMetadata(
		apolloengine.RenderObjectMeshFileMetadate(mu, meshpath));
  
  local res = self.render:CreateResource();
      
  --skeleton
  if(animationpath) then
    self.skeleton = apolloengine.SkeletonComponent();
    self.node:AttachComponent(self.skeleton);
    self.frameCount = 0;
    --self.skeleton:PushMetadata(apolloengine.PathMetadata(skeletonPath),apolloengine.PathMetadata(animationpath));
    self.skeleton:PushMetadata(apolloengine.SkeletonAnimationFileMetaData(aniType,skeletonPath,animationpath));
    
    res = res and self.skeleton:CreateResource();
    --set default interval
    self.skeleton:SetAnimationInterval(0,frameCount-1);
    self.frameCount = frameCount;
  end
  return res;
end

function MeshNode:UpdateAnimation(def)
  if self.skeleton==nil then
    return
  end
  return self.skeleton:UpdateAnimation(def);
end

function MeshNode:SetLoop(loop)
  if self.skeleton==nil then
    return
  end
  self.skeleton:Loop(loop);

end

function MeshNode:Reset(frame)
  if self.skeleton==nil then
    return
  end
  if frame then
    self.skeleton:Reset(frame)
  else
    self.skeleton:Reset()
  end  
end

function MeshNode:Play()
  if self.skeleton==nil then
    return
  end
  self.skeleton:Play()
end

function MeshNode:Stop()
  if self.skeleton==nil then
    return
  end
  self.skeleton:Stop()
end

function MeshNode:SetAnimationInterval(from,to)
  if from < 0 then
    from = 0;
  end
  
  if to > self.frameCount-1 then
    to = self.frameCount-1;
  end
  
  self.skeleton:SetAnimationInterval(from,to);
end

function MeshNode:GetFrameCount()
  return self.frameCount;
end

function MeshNode:AttachNodeToJoint(jointName,node)
  if self.skeleton==nil then
    return
  end
  self.skeleton:AttachNodeToJoint(jointName,node);
end






return MeshNode;