local TransNode = require "apolloutility.apollonode.trasnnode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

--灯光节点
local LightNode = TransNode:extend();

function LightNode:new(lightType)
  LightNode.super.new(self)
  self.light = apolloengine.LightComponent(lightType);
  self.node:AttachComponent(self.light);
end


function LightNode:SetColor(c)
  self.light:SetColor(c);
end

function LightNode:SetLocalDirection(d)
  self.light:SetLocalDirection(d);
end

function LightNode:SetRange(r)
  self.light:SetRange(r);
end

function LightNode:SetLightAngle(angle)
  self.light:SetLightAngle(angle);
end


function LightNode:EnableShadowCaster()
  self.light:EnableShadowCaster();
end

function LightNode:DisableShadowCaster()
  self.light:DisableShadowCaster();
end



return LightNode;
