local rendernode = require "apolloutility.apollonode.rendernode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"


local CircleNode = rendernode:extend();

function CircleNode:new()
  apolloengine.ShaderEntity.ATTRIBUTE_RADIUS =
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.ATTRIBUTE,
      "ATTRIBUTE_RADIUS");

  CircleNode.super.new(self);
  self.vertexstream = apolloengine.VertexStream();--创建顶点流
  self.indicesstream = apolloengine.IndicesStream();--创建索引流
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
    4);
	self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_RADIUS,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
    1);
  self.indicesstream:SetIndicesType(
    apolloengine.IndicesBufferEntity.IT_UINT16);
end


--传入圆心偏移，点的数量，材质，来创建一个可渲染的圆
function CircleNode:CreateResource(centeroffset, radius, pointcount, material)
  self.vertexstream:ReserveBuffer(pointcount + 1);--预先分配pointcount + 1个顶点的内存
  self.indicesstream:ReserveBuffer(pointcount + 2);--预先分配pointcount + 2个索引

  --圆心
  local vec4 = mathfunction.vector4(
    centeroffset:x(),
    centeroffset:y(),
    0,1);

  self.vertexstream:PushVertexData(
    apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    vec4);
	self.vertexstream:PushVertexData(
		apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		mathfunction.vector2(0,0));
  self.vertexstream:PushVertexData(
    apolloengine.ShaderEntity.ATTRIBUTE_RADIUS,
    mathfunction.vector1(0));
  self.indicesstream:PushIndicesData(0);

  --初始化一个半径为radius的圆
  for i=1, pointcount do
    self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
      mathfunction.vector4(-radius*math.sin(2*math.pi*i/pointcount),radius*math.cos(2*math.pi*i/pointcount),0,1)
    );
		self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
      mathfunction.vector2(-radius*math.sin(2*math.pi*i/pointcount),radius*math.cos(2*math.pi*i/pointcount))
    );
    self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_RADIUS,
      mathfunction.vector1(1));
    self.indicesstream:PushIndicesData(i);
  end

  self.indicesstream:PushIndicesData(1);

  --第三个参数修改为索引模式（RM_TRIANGLES等）
  return CircleNode.super.CreateResource(
    self,
    material,
    apolloengine.RenderObjectEntity.RM_TRIANGLE_FAN,
    self.vertexstream,
    self.indicesstream);
end

return CircleNode;
