local mathfunction = require "mathfunction"
local apologine = require "apolloengine"
local venuscore = require "venuscore"
require "utility"



local ParticleUpdateAgent = {}


function ParticleUpdateAgent:Initialize(agent, callbackindex)
  self.agent = agent;
  self.callbackindex = callbackindex;
  self.Schedulelist = {};
end

function ParticleUpdateAgent:Scheduled(emitter, span)
  table.insert(self.Schedulelist, {emitter, span});
end


function ParticleUpdateAgent:AsyncUpdate()
  for _, pair in ipairs(self.Schedulelist) do
    local emitter = pair[1];
    if emitter then
      emitter:Update(pair[2]);
    end    
  end
  self.Schedulelist = {}
  self.agent:CallbackFunction(self.callbackindex);
end

function ParticleUpdateAgent:Clear()
  collectgarbage();
end

return ParticleUpdateAgent;
