
#SHADER_DEFINE RGBSeperateVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCoordinate"},
		{ UNIFORM_SCALE_R,             	MEDIUM, VEC2,   	"Scale_R"},
		{ UNIFORM_OFFSET_R,             MEDIUM, VEC2,   	"Offset_R"},
		{ UNIFORM_SCALE_G,             	MEDIUM, VEC2,   	"Scale_G"},
		{ UNIFORM_OFFSET_G,             MEDIUM, VEC2,   	"Offset_G"},
		{ UNIFORM_SCALE_B,             	MEDIUM, VEC2,   	"Scale_B"},
		{ UNIFORM_OFFSET_B,             MEDIUM, VEC2,   	"Offset_B"},
	}
	FUNCTION_OUTPUT =
	{
        { ATTRIBUTE_COORDNATE_R,			HIGH,	VEC2,		"out_TexCooridateR" },
		{ ATTRIBUTE_COORDNATE_G,			HIGH,	VEC2,		"out_TexCooridateG" },
		{ ATTRIBUTE_COORDNATE_B,			HIGH,	VEC2,		"out_TexCooridateB" }
	}

#SHADER_CODE

    gl_Position = in_Position;  
    mediump vec2 out_TexCooridateR;
	mediump vec2 out_TexCooridateG;
 	mediump vec2 out_TexCooridateB;
    out_TexCooridateR= (in_TexCoordinate.xy-Offset_R)/Scale_R; 
	out_TexCooridateG= (in_TexCoordinate.xy-Offset_G)/Scale_G; 
	out_TexCooridateB= (in_TexCoordinate.xy-Offset_B)/Scale_B; 
 
#END_CODE

#END_DEFINE


#SHADER_DEFINE RGBSeperateFragment

	FUNCTION_INPUT = 
	{
        { TEXTURE_SCREEN,		    	NONE,	TEXTURE2D,	  "ScreenTex" },
		{ UNIFORM_USE_BORDER,           MEDIUM, VEC2,   	  "UseBorder"},
        { ATTRIBUTE_COORDNATE_R,		HIGH,	VEC2,		  "vUV_R"},
		{ ATTRIBUTE_COORDNATE_G,		HIGH,	VEC2,	  	  "vUV_G"},
		{ ATTRIBUTE_COORDNATE_B,		HIGH,	VEC2,		  "vUV_B"}
	}
  
#SHADER_CODE
	mediump vec4 color;
	mediump float temp;
	temp= texture2D(ScreenTex, vUV_R).r;
	color.r = ((vUV_R.x<0.0||vUV_R.x>1.0)&&UseBorder.x>0.0)||((vUV_R.y<0.0||vUV_R.y>1.0)&&UseBorder.y>0.0)? 0.0: temp;
    temp = texture2D(ScreenTex, vUV_G).g;
	color.g = ((vUV_G.x<0.0||vUV_G.x>1.0)&&UseBorder.x>0.0)||((vUV_G.y<0.0||vUV_G.y>1.0)&&UseBorder.y>0.0)? 0.0: temp;
    temp = texture2D(ScreenTex, vUV_B).b;
	color.b = ((vUV_B.x<0.0||vUV_B.x>1.0)&&UseBorder.x>0.0)||((vUV_B.y<0.0||vUV_B.y>1.0)&&UseBorder.y>0.0)? 0.0: temp;
	color.a = 1.0;

    gl_FragColor = color;
#END_CODE

#END_DEFINE