//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in
//	all copies or substantial portions of the Software. And the logo of
//	Bohge Engine shall be displayed full screen for more than 3 seconds
//	when the software is started. Copyright holders are allowed to develop
//	game edit based on Bohge Engine, The edit must be released under the MIT
//	open source license if it is going to be published. In no event shall
//	copyright holders be prohibited from using any code of Bohge Engine
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////


// 输出纹理坐标 等于 输入纹理坐标
#SHADER_DEFINE Base2DCoordinate
    FUNCTION_INPUT =
    {
        { ATTRIBUTE_COORDNATE0,            MEDIUM,    VEC2,        "in_Coordinate" },
    }

    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,            MEDIUM,    VEC2,        "Out_Coordinate" },
    }
#SHADER_CODE
    mediump vec2 Out_Coordinate = in_Coordinate;
#END_CODE
#END_DEFINE


//输出在世界空间下的顶点属性
//输出两个变换矩阵
#SHADER_DEFINE TransfromWorldPosition
    FUNCTION_INPUT =
    {
        { CAMERA_VIEWPROJ,						HIGH,    MAT4,        "in_ViewPorj" },
        { LOCALWORLD_TRANSFORM,				HIGH,    MAT4,        "in_Transfrom" },
        { LOCALWORLD_ROTATION,				HIGH,    MAT3,        "in_WorldRotation" },
        { ATTRIBUTE_POSITION,					HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_NORMAL,						HIGH,    VEC3,        "in_Normal" },
				{	ATTRIBUTE_TANGENT,					HIGH,    VEC3,        "in_Tangent"},
    }
    FUNCTION_OUTPUT =
    {
        { SCREENSPACE_POSITION,     	HIGH,    VEC4,        "out_Position" },
				{ WORLDSPACE_POSITION,        HIGH,    VEC3,        "out_PositionWS" },
        { WORLDSPACE_NORMAL,         	HIGH,    VEC3,        "out_NormalWS" },
				{	W2T_TBN_MAT,										HIGH,   MAT3,         "W2T_TBN"},
				{	T2W_TBN_MAT,										HIGH,   MAT3,         "T2W_TBN"},

    }
#SHADER_CODE
		vec4 out_Position = in_ViewPorj * in_Transfrom * in_Position;

		vec3 out_PositionWS  = vec3(in_Transfrom * in_Position);
    vec3 out_NormalWS = (in_WorldRotation * in_Normal);
		vec3 out_TangentWS =  (in_WorldRotation * in_Tangent);
		vec3 out_BiTangentWS = (cross(out_TangentWS, out_NormalWS));
		mat3 T2W_TBN = mat3(out_TangentWS,out_BiTangentWS,out_NormalWS);//从切线空间转到世界空间的矩阵
		mat3 W2T_TBN = mat3(
		vec3(out_TangentWS.x,out_BiTangentWS.x,out_NormalWS.x),
		vec3(out_TangentWS.y,out_BiTangentWS.y,out_NormalWS.y),
		vec3(out_TangentWS.z,out_BiTangentWS.z,out_NormalWS.z));//从世界空间转到切线空间的矩阵

#END_CODE
#END_DEFINE


// 光源的ViewDir和LightDir的输出
#SHADER_DEFINE PointLightVertex
    FUNCTION_INPUT =
    {
			{	W2T_TBN_MAT,										HIGH,   MAT3,         "W2T_TBN"},
			{ CAMERA_WORLDPOSITION,			MEDIUM,		VEC3,					"in_CameraPosition"},
			{ WORLDSPACE_POSITION,        HIGH,    VEC3,        "in_PositionWS" },
			{ LIGHT_POSITION, 					MEDIUM,		VEC3,				"in_LightPosition"},
    }
    FUNCTION_OUTPUT =
		{
				{	WORLDSPACE_VIEWDIRECTION,				LOW,			VEC3,					"out_ViewDirection"},
				{	LIGHT_VERTEX_DIRECTION,				LOW,			VEC3,					"out_LightDirection"},
		}
#SHADER_CODE
		vec3 out_ViewDirection =  W2T_TBN*(in_CameraPosition - in_PositionWS);
		vec3 out_LightDirection = W2T_TBN*(in_PositionWS - in_LightPosition);
		//vec3 out_LightDirection = (in_LightPosition);
#END_CODE
#END_DEFINE


// 平行光源的ViewDir的输出，将平行光的方向转换到切线空间下
#SHADER_DEFINE DirectionLightVertex

	FUNCTION_INPUT = 
	{
		{	W2T_TBN_MAT,										HIGH,   MAT3,         "W2T_TBN"},
		{ CAMERA_WORLDPOSITION,		HIGH,	VEC3,	"in_CameraPosition" },
		{ WORLDSPACE_POSITION,		HIGH,	VEC4,	"in_PositionWS" },
		{ LIGHT_GIVEN_DIRECTION,		MEDIUM,		VEC3,		"in_LightDirection" },
	}

	FUNCTION_OUTPUT = 
	{
		{ WORLDSPACE_VIEWDIRECTION,	HIGH,	VEC3,	"out_ViewDirection" },
		{ LIGHT_GIVEN_DIRECTION, MEDIUM,		VEC3,		"out_LightDirection"}
	}

#SHADER_CODE
	vec3 out_ViewDirection =  W2T_TBN*(in_CameraPosition - in_PositionWS);
	vec3 out_LightDirection = W2T_TBN*in_LightDirection;

#END_CODE
#END_DEFINE


// 顶点的坐标等于屏幕空间下的位置
#SHADER_DEFINE VertexOutput
    FUNCTION_INPUT =
    {
        { SCREENSPACE_POSITION,        HIGH,    VEC4,    "in_ScreenPosition" },
    }
    FUNCTION_OUTPUT = { }
#SHADER_CODE
    gl_Position = in_ScreenPosition;
#END_CODE
#END_DEFINE


// 采样纹理的着色器
// 得到PBR需要用到的相关信息，比如金属度、粗糙度以及切线空间下的法向量等
#SHADER_DEFINE PBRTexture2DSampling

    FUNCTION_INPUT =
    {
				{ TEXTURE_ALDEBO,						NONE,			TEXTURE2D,		"albedoMap" },
				{ TEXTURE_METALLIC,					NONE,			TEXTURE2D,		"metallicMap" },
				{ TEXTURE_ROUGHNESS,				NONE,			TEXTURE2D,		"roughnessMap" },
        { TEXTURE_AMR,              NONE,     TEXTURE2D,    "AoRoughnessMetallicMap"},
        { ATTRIBUTE_COORDNATE0,			MEDIUM,		VEC2,					"in_Coordinate" },
				{ TEXTURE_NORMAL,					NONE,			TEXTURE2D,		"normalMap" },
				{ WORLDSPACE_POSITION,		MEDIUM,		VEC3,					"WorldPos"},
				{ WORLDSPACE_NORMAL,			MEDIUM,		VEC3,					"Normal"},
    }

    FUNCTION_OUTPUT =
    {
        { ALBEDO_COLOR,					LOW,			VEC3,					"albedo" },
				{ METALLIC_VALUE,				HIGH,			FLOAT,				"metallic" },
				{ ROUGHNESS_VALUE,			HIGH,			FLOAT,				"roughness" },
				{ TANGENTSPACE_NORMAL,	LOW,			VEC3,					"Normal_TangentSpace" },
				{	Base_Reflectivity,				LOW,			VEC3,					"F0"},
    }

#SHADER_CODE
		vec3 albedo		 = pow(texture2D(albedoMap, in_Coordinate).rgb, vec3(2.2));
    vec3 ao_roughness_metallic = texture2D(AoRoughnessMetallicMap,in_Coordinate).rgb;
    float ao = ao_roughness_metallic.r;
    float roughness = ao_roughness_metallic.g;
    float metallic = ao_roughness_metallic.b;
	albedo = albedo * ao; //考虑ao
		//float metallic	= texture2D(metallicMap, in_Coordinate).a;
		//float roughness = texture2D(roughnessMap, in_Coordinate).a;
		vec3 Normal_TangentSpace;
		{
			vec3 tangentNormal_tmp = texture2D(normalMap, in_Coordinate).xyz * 2.0 - 1.0;
			Normal_TangentSpace = normalize(tangentNormal_tmp);
		}
		vec3 F0 = vec3(0.04);
		F0 = mix(F0, albedo, metallic);
#END_CODE
#END_DEFINE




// 计算得到点光源对片元的影响
#SHADER_DEFINE PointLight

    FUNCTION_INPUT =
    {
				
				{ LIGHT_VERTEX_DIRECTION,				LOW,			VEC3,					"in_LightDirection"},
				{ LIGHT_RANGE_INV,				MEDIUM,		FLOAT,		"in_RangeInv" },
				{ LIGHT_ATTENUATION,			MEDIUM,		VEC4,		"in_LinghtAtten" },
				{ LIGHT_COLOR, 							MEDIUM,		VEC3,					"in_LightColor"},
    }

    FUNCTION_OUTPUT =
    {

				{ LIGHT_GIVEN_DIRECTION,		MEDIUM,		VEC3,		"out_LightDirection" },
				{ LIGHT_COLOR, 							MEDIUM,		VEC3,					"out_LightColor"},
    }

#SHADER_CODE
// reflectance equation
// light output
vec3 out_LightDirection;
vec3 out_LightColor;
{
	// calculate per-light
	float distance = length( in_LightDirection );
	float distanceRange = clamp( distance * in_RangeInv, 0.0, 1.0 );
	float attenuation = (1.0 - distanceRange) / ( in_LinghtAtten.x + distanceRange * in_LinghtAtten.y + distanceRange * distanceRange * in_LinghtAtten.z );

	out_LightDirection =  in_LightDirection;
	out_LightColor = in_LightColor*attenuation;
}

#END_CODE
#END_DEFINE


//---------------------------------------------------------------------------



// 计算得到聚光灯对片元的影响
#SHADER_DEFINE SpotLight

    FUNCTION_INPUT =
    {
				
				{ LIGHT_VERTEX_DIRECTION,				LOW,			VEC3,					"in_LightDirection"},
				{ LIGHT_GIVEN_DIRECTION,		MEDIUM,		VEC3,		"in_SpotDirection" },
				
				{ LIGHT_RANGE_INV,				MEDIUM,		FLOAT,		"in_RangeInv" },
				{ LIGHT_ATTENUATION,			MEDIUM,		VEC4,		"in_LinghtAtten" },
				{ LIGHT_INNER_DIFF_INV,			MEDIUM,		VEC2,		"in_vInner_DiffInv" },
			
				{ LIGHT_COLOR, 					MEDIUM,		VEC3,					"in_LightColor"},
	}

    FUNCTION_OUTPUT =
    {
				{ LIGHT_GIVEN_DIRECTION,		MEDIUM,		VEC3,		"out_LightDirection" },
				{ LIGHT_COLOR, 							MEDIUM,		VEC3,					"out_LightColor"},
    }

#SHADER_CODE
// reflectance equation
// light output
vec3 out_LightDirection;
vec3 out_LightColor;
{
	// calculate per-light
	vec3 vLight = normalize(-in_LightDirection);

	float distance = length( in_LightDirection );
	float distanceRange = clamp( distance * in_RangeInv, 0.0, 1.0 );
	float attenuation = (1.0 - distanceRange ) / ( in_LinghtAtten.x + distanceRange * in_LinghtAtten.y + distanceRange * distanceRange * in_LinghtAtten.z );

	lowp float attenAngle = clamp( 1.0 - ( in_vInner_DiffInv.x - dot(vLight, -in_SpotDirection) ) * in_vInner_DiffInv.y, 0.0, 1.0 );
	attenuation *= attenAngle;
	out_LightColor = in_LightColor*attenuation;
	out_LightDirection = in_LightDirection;
}

#END_CODE
#END_DEFINE


// 计算得到平行光对片元的影响
#SHADER_DEFINE PBRLightingSurface

    FUNCTION_INPUT =
    {
				{ TANGENTSPACE_NORMAL,						LOW,			VEC3,					"in_Normal" },
				{ LIGHT_GIVEN_DIRECTION,		MEDIUM,		VEC3,		"in_LightDirection" },
				{	WORLDSPACE_VIEWDIRECTION,				LOW,			VEC3,					"in_ViewDirection"},
				{ ALBEDO_COLOR,							LOW,			VEC3,					"albedo" },
				{ METALLIC_VALUE,						HIGH,			FLOAT,				"metallic" },
				{ ROUGHNESS_VALUE,					HIGH,			FLOAT,				"roughness" },
				{ LIGHT_COLOR, 							MEDIUM,		VEC3,					"in_LightColor"},
				{	Base_Reflectivity,				LOW,			VEC3,					"F0"},
    }

    FUNCTION_OUTPUT =
    {
				{ LIGHTING_DIFFUSE,				LOW,	VEC3,		"out_Diffuse" },
				{ LIGHTING_SPECULAR,			LOW,	VEC3,		"out_Specular" },
				{ TANGENTSPACE_NORMAL,			LOW,			VEC3,		"vNormal" },
				{ WORLDSPACE_VIEWDIRECTION,				LOW,			VEC3,					"vView"},
    }

#SHADER_CODE
const float PI = 3.14159265359;

// reflectance equation
// light output
vec3 out_Diffuse;
vec3 out_Specular;
vec3 vNormal = normalize(in_Normal);

float length = sqrt(dot(in_ViewDirection,in_ViewDirection));
length = 1.0/length;
vec3 vView=in_ViewDirection*length;
vec3 vLight = normalize(-in_LightDirection);
vec3 vHalf = normalize(vView + vLight);
{
	
	// Cook-Torrance BRDF
	// DistributionGGX
	float NDF;
	//------------------------------------------
	{
		float a = roughness*roughness;
		float a2 = a*a;
		float NdotH = max( dot(vNormal, vHalf) , 0.0 );
		float NdotH2 = NdotH * NdotH;

		float nom	 = a2;
		float denom = (NdotH2 * (a2 - 1.0) + 1.0);
		denom = PI * denom * denom;

		NDF = nom / denom;

	}
	//------------------------------------------

	//GeometrySmith
	float G;
	//------------------------------------------
	{
		float NdotV = max(dot(vNormal, vView), 0.0);
		float NdotL = max(dot(vNormal, vLight), 0.0);

		float a = roughness;
		float lambdaV = NdotL * (NdotV * (1.0 - a) + a);
    	float lambdaL = NdotV * (NdotL * (1.0 - a) + a);

		G = 0.5 / (lambdaV + lambdaL + 1e-5f);
	}
	//------------------------------------------

	//fresnelSchlick
	vec3  F;
	//------------------------------------------
	{
		float cosTheta = max(dot(vHalf, vView), 0.0);
		F = F0 + (1.0 - F0) * pow(1.0 - cosTheta, 5.0);
	}
	//------------------------------------------
	// Main Physically Based BRDF
	// Derived from Disney work and based on Torrance-Sparrow micro-facet model
	//
	//   BRDF = kD / pi + kS * (D * V * F) / 4
	//   I = BRDF * NdotL
	vec3 nominator		= NDF * G * F *3.14;
	vec3 specular = nominator;// / denominator;

	// kS is equal to Fresnel
	vec3 kS = F;
	// for energy conservation, the diffuse and specular light can't
	// be above 1.0 (unless the surface emits light); to preserve this
	// relationship the diffuse component (kD) should equal 1.0 - kS.
	vec3 kD = vec3(1.0) - kS;
	// multiply kD by the inverse metalness such that only non-metals
	// have diffuse lighting, or a linear blend if partly metal (pure metals
	// have no diffuse light).
	kD *= 1.0 - metallic;

  
	// scale light by NdotL
	float NdotL = max(dot(vNormal, vLight), 0.0);

	out_Diffuse = kD * albedo / PI * NdotL * in_LightColor;
	out_Specular =  specular * NdotL* in_LightColor;//(vNormal+vec3(1.0))/2.0;//
}

#END_CODE
#END_DEFINE


//---------------------------------------------------------------------------




//-------------------------------------------------------------------------

//计算得到环境光照对片元的影响
#SHADER_DEFINE PBRIBLLightingSurface

	FUNCTION_INPUT =
	{
			{ ALBEDO_COLOR,							LOW,			VEC3,					"albedo" },
			{ METALLIC_VALUE,						HIGH,			FLOAT,				"metallic" },
			{ ROUGHNESS_VALUE,					HIGH,			FLOAT,				"roughness" },
			{ TANGENTSPACE_NORMAL,						LOW,			VEC3,					"in_Normal" },
			{	WORLDSPACE_VIEWDIRECTION,					LOW,			VEC3,					"in_ViewDirection"},
			{	Base_Reflectivity,						LOW,			VEC3,					"F0"},

			{ SKY_BOX, 									NONE, 		TEXTURECUBE,	"skybox"},
			{	T2W_TBN_MAT,							HIGH,   MAT3,         "T2W_TBN"},
	}
	FUNCTION_OUTPUT =
	{
			{	IBL_DIFFUSE_COLOR,    LOW,    VEC3,        "IBL_diffuse"},
			{	IBL_SPECULAR_COLOR,    LOW,    VEC3,        "IBL_specular"},
	}

#SHADER_CODE

		vec3 kS;// 反射部分 镜面效果 所占的比例
		//------------------------------------------	
		float cosTheta = max(dot(in_Normal, in_ViewDirection), 0.0);
		kS = F0 + (max(vec3(1.0-roughness),F0) - F0) * pow(1.0 - cosTheta, 5.0);

		vec3 worldnormal = (T2W_TBN)*in_Normal;//镜面反射射线
		//------------------------------------------
		vec3 kD = 1.0 - kS; // 折射 漫反射效果 所占的比例
		kD *= 1.0 - metallic;// 金属性越强，漫反射越少, 折射越多
		vec3 irradiance = textureCube(skybox, worldnormal, 4.0).rgb ;
		vec3 IBL_diffuse = (kD) * ( albedo ) * irradiance;//漫反射效果


		
		vec3 R = reflect(-in_ViewDirection, in_Normal);//镜面反射射线
		const float MAX_REFLECTION_LOD = 8.0;
		vec3 prefilteredColor	= textureCube(skybox, ((T2W_TBN))*R , MAX_REFLECTION_LOD*roughness ).rgb;

		vec3 refColor = vec3(0.04);
		refColor = mix(refColor, albedo, metallic);

		float smoothness = 1.0-roughness;
		float surfaceReduction = 1.0-0.28*roughness*roughness*roughness; 

		float oneMinusReflectivity = 0.96 - metallic*0.04; 
		oneMinusReflectivity = smoothness + (1.0- oneMinusReflectivity);
		float grazingTerm = clamp(oneMinusReflectivity,0.0,1.0);

		float t = 1.0 - cosTheta;   // ala Schlick interpoliation
		t = t*t*t*t*t;
    	refColor = mix (refColor, vec3(grazingTerm), t);
        vec3 IBL_specular = surfaceReduction * prefilteredColor * refColor;



#END_CODE
#END_DEFINE

//-------------------------------------------------------------------------


//计算得到环境光照对片元的影响
//（不使用环境贴图，所以需要手动设定一个反射颜色值）
#SHADER_DEFINE PBRConstIBLLightingSurface

	FUNCTION_INPUT =
	{
			{ ALBEDO_COLOR,							LOW,			VEC3,					"albedo" },
			{ METALLIC_VALUE,						HIGH,			FLOAT,				"metallic" },
			{ ROUGHNESS_VALUE,					HIGH,			FLOAT,				"roughness" },
			{ TANGENTSPACE_NORMAL,						LOW,			VEC3,					"in_Normal" },
			{	WORLDSPACE_VIEWDIRECTION,					LOW,			VEC3,					"in_ViewDirection"},
			{	Base_Reflectivity,						LOW,			VEC3,					"F0"},
			{ AMBIENT_COLOR,		LOW,		VEC3,		"in_Ambient_Light" },
	}
	FUNCTION_OUTPUT =
	{
			{	IBL_DIFFUSE_COLOR,    LOW,    VEC3,        "IBL_diffuse"},
			{	IBL_SPECULAR_COLOR,    LOW,    VEC3,        "IBL_specular"},
	}

#SHADER_CODE


		vec3 kS;// 反射部分 镜面效果 所占的比例
		//------------------------------------------
		
		float cosTheta = max(dot(in_Normal, in_ViewDirection), 0.0);
		kS = F0 + (max(vec3(1.0-roughness),F0) - F0) * pow(1.0 - cosTheta, 5.0);
		
		//------------------------------------------
		vec3 kD = 1.0 - kS; // 折射 漫反射效果 所占的比例
		kD *= 1.0 - metallic;// 金属性越强，漫反射越少, 折射越多
	
		vec3 irradiance = in_Ambient_Light;
		vec3 IBL_diffuse = (kD) * ( albedo ) * irradiance;//漫反射效果

		vec3 refColor = vec3(0.04);
		refColor = mix(refColor, albedo, metallic);

		float smoothness = 1.0-roughness;
		float surfaceReduction = 1.0-0.28*roughness*roughness*roughness; 

		float oneMinusReflectivity = 0.96 - metallic*0.04; 
		oneMinusReflectivity = smoothness + (1.0- oneMinusReflectivity);
		float grazingTerm = clamp(oneMinusReflectivity,0.0,1.0);

		float t = 1.0 - cosTheta;   // ala Schlick interpoliation
		t = t*t*t*t*t;
    	refColor = mix (refColor, vec3(grazingTerm), t);
        vec3 IBL_specular = surfaceReduction * in_Ambient_Light * refColor;

#END_CODE
#END_DEFINE




//-------------------------------------------------------------------------

//整合直接光照和环境光照的效果，输出到片元
#SHADER_DEFINE FragmentOutput

    FUNCTION_INPUT =
    {
			{ LIGHTING_DIFFUSE,				LOW,	VEC3,		"light_Diffuse" },
			{ LIGHTING_SPECULAR,			LOW,	VEC3,		"light_Specular" },
			{	IBL_DIFFUSE_COLOR,    LOW,    VEC3,        "IBL_diffuse"},
			{	IBL_SPECULAR_COLOR,    LOW,    VEC3,        "IBL_specular"},
    }
    FUNCTION_OUTPUT = { }

#SHADER_CODE
		//环境贴图对当前片元颜色的贡献
		vec3 ambient =  IBL_diffuse + IBL_specular ;
		//光源对当前片元颜色的贡献
		vec3 color =  light_Specular+light_Diffuse+ambient;

		// HDR tonemapping
		//color = color / (color + vec3(1.0));

		// gamma correct
		color = pow(color, vec3(1.0/2.2));
		gl_FragColor = vec4(color,1.0);

#END_CODE
#END_DEFINE

//-------------------------------------------------------------------------
