#SHADER_DEFINE InterlaceVertex
    FUNCTION_INPUT = 
    {
        { ATTRIBUTE_POSITION,       HIGH,	  VEC4,  "in_Position" },
        { ATTRIBUTE_COORDNATE0,     HIGH,	  VEC2,  "in_TexCoord"},
    }

    FUNCTION_OUTPUT = 
    {
        { ATTRIBUTE_COORDNATE0,     HIGH,   VEC2,  "out_TexCoord" },
    }
    
#SHADER_CODE
    vec2 out_TexCoord = in_TexCoord;
    gl_Position = in_Position;
#END_CODE
#END_DEFINE

#SHADER_DEFINE InterlaceFragment
  FUNCTION_INPUT = 
  {
    { FRAME_SIZE,              HIGH,    FLOAT,          "in_FrameSize"},
    { CUR_FRAME_ID,            HIGH,    FLOAT,          "in_CurFrameID"},
    { ROW_FRAME_NUM_PER_TEX,   HIGH,    FLOAT,          "in_RowFrameNumPerTex"},
    { COL_FRAME_NUM_PER_TEX,   HIGH,    FLOAT,          "in_ColFrameNumPerTex"},
    { HISTORICAL_FRAME1,       NONE,    TEXTURE2D,      "in_Tex1" },
    { HISTORICAL_FRAME2,       NONE,    TEXTURE2D,      "in_Tex2" },
    { HISTORICAL_FRAME3,       NONE,    TEXTURE2D,      "in_Tex3" },
    { HISTORICAL_FRAME4,       NONE,    TEXTURE2D,      "in_Tex4" },
    { INTERLACE_MODE,          HIGH,    FLOAT,          "in_InterlaceMode"}, 
    { TIME_FACTOR,             HIGH,    FLOAT,          "in_TimeFactor"},
    { WAVE_FACTOR,             HIGH,    FLOAT,          "in_WaveFactor"},
    { INTERLACE_OFFSET_TEX,    NONE,    TEXTURE2D,      "in_InterlaceOffsetTex"},
    { ATTRIBUTE_COORDNATE0,	   HIGH,	  VEC2,           "in_TexCoord"}
  }
  
#SHADER_CODE
    float TWO_PI = 2.0 * 3.1415926;    

    int iRowFrameNumPerTex = int(in_RowFrameNumPerTex);
    int iColFrameNumPerTex = int(in_ColFrameNumPerTex);

    int FRAME_NUM_PER_TEX  = iRowFrameNumPerTex * iColFrameNumPerTex;
    
    float ratio = 0.0;
    float sin_pos = sin(TWO_PI * (in_TexCoord.x + in_TexCoord.y + in_TimeFactor));
    float sin_t  = sin(TWO_PI * in_TimeFactor);
    
    if(in_InterlaceMode > 0.0)
    {
        ratio = in_TexCoord.y + 0.1 * in_WaveFactor * (0.5 * sin_t + sin_t * sin_t) *
                (in_TexCoord.x * in_TexCoord.x + 0.5 * in_TexCoord.x) * sin_pos * sin_pos;
    }
    else
    {       
        ratio = in_TexCoord.x + 0.1 * in_WaveFactor * (0.5 * sin_t + sin_t * sin_t) *
                (in_TexCoord.y * in_TexCoord.y + 0.5 * in_TexCoord.y) * sin_pos * sin_pos;
    }
    
    int frame_offset = int(255.0 * texture2D(in_InterlaceOffsetTex, vec2(ratio, 0.)).r);

    int a = int(in_CurFrameID) - frame_offset + int(in_FrameSize);
    int b = int(in_FrameSize);
    int frame_id = a - b * (a / b);

    int tex_id         = frame_id / FRAME_NUM_PER_TEX;
    int local_frame_id = frame_id - FRAME_NUM_PER_TEX * tex_id;
    
    float x_scale = 1.0 / in_RowFrameNumPerTex;
    float y_scale = 1.0 / in_ColFrameNumPerTex;

    int   row_id      = local_frame_id / iRowFrameNumPerTex;
    float tex_x_start = x_scale * float(local_frame_id - iRowFrameNumPerTex * row_id);
    float tex_y_start = y_scale * float(iColFrameNumPerTex - 1 - row_id);

    vec2 tex_pos = vec2(tex_x_start, tex_y_start) + vec2(x_scale, y_scale) * in_TexCoord;
    
    vec3 rgb = vec3(0.0, 0.0, 0.0);
    if (tex_id == 0)
        rgb = texture2D(in_Tex1, tex_pos).rgb;
    else if (tex_id == 1)
        rgb = texture2D(in_Tex2, tex_pos).rgb;
    else if (tex_id == 2)
        rgb = texture2D(in_Tex3, tex_pos).rgb;
    else if (tex_id == 3)
        rgb = texture2D(in_Tex4, tex_pos).rgb;
        
    gl_FragColor = vec4(rgb, 1.0);
#END_CODE
#END_DEFINE